/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.websocket;

import io.helidon.http.HttpPrologue;
import io.helidon.http.NotFoundException;
import io.helidon.http.PathMatchers;
import io.helidon.webserver.Routing;
import io.helidon.webserver.websocket.WsRoute;
import io.helidon.websocket.WsListener;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class WsRouting
implements Routing {
    private static final WsRouting EMPTY = WsRouting.builder().build();
    private final List<WsRoute> routes;

    private WsRouting(Builder builder) {
        this.routes = new ArrayList<WsRoute>(builder.routes);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static WsRouting empty() {
        return EMPTY;
    }

    public void beforeStart() {
        for (WsRoute route : this.routes) {
            route.beforeStart();
        }
    }

    public void afterStop() {
        for (WsRoute route : this.routes) {
            route.afterStop();
        }
    }

    public WsRoute findRoute(HttpPrologue prologue) {
        for (WsRoute route : this.routes) {
            PathMatchers.MatchResult accepts = route.accepts(prologue);
            if (!accepts.accepted()) continue;
            return route;
        }
        throw new NotFoundException("No WebSocket route available for " + String.valueOf(prologue));
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, WsRouting> {
        private final List<WsRoute> routes = new ArrayList<WsRoute>();

        private Builder() {
        }

        public WsRouting build() {
            return new WsRouting(this);
        }

        public Builder endpoint(String path, WsListener listener) {
            return this.route(WsRoute.create(path, listener));
        }

        public Builder endpoint(String path, Supplier<WsListener> listener) {
            return this.route(WsRoute.create(path, listener));
        }

        private Builder route(WsRoute wsRoute) {
            this.routes.add(wsRoute);
            return this;
        }
    }
}

