/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.reactive.Flow;
import io.helidon.common.reactive.RequestedCounter;
import io.helidon.common.reactive.SingleSubscriberHolder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;

@Deprecated
class InputStreamPublisher
implements Flow.Publisher<ByteBuffer> {
    private final InputStream inputStream;
    private final byte[] buffer;
    private final SingleSubscriberHolder<ByteBuffer> subscriber = new SingleSubscriberHolder();
    private final RequestedCounter requested = new RequestedCounter();
    private final AtomicBoolean publishing = new AtomicBoolean(false);

    InputStreamPublisher(InputStream inputStream, int bufferSize) {
        this.inputStream = inputStream;
        this.buffer = new byte[bufferSize];
    }

    public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriberParam) {
        if (this.subscriber.register(subscriberParam)) {
            this.publishing.set(true);
            try {
                subscriberParam.onSubscribe(new Flow.Subscription(){

                    public void request(long n) {
                        InputStreamPublisher.this.requested.increment(n, t -> InputStreamPublisher.this.tryComplete(t));
                        InputStreamPublisher.this.tryPublish();
                    }

                    public void cancel() {
                    }
                });
            }
            finally {
                this.publishing.set(false);
            }
            this.tryPublish();
        }
    }

    private void tryPublish() {
        while (!this.subscriber.isClosed() && this.requested.get() > 0L && this.publishing.compareAndSet(false, true)) {
            try {
                Flow.Subscriber sub = this.subscriber.get();
                while (!this.subscriber.isClosed() && this.requested.tryDecrement()) {
                    int len = this.inputStream.read(this.buffer);
                    if (len >= 0) {
                        sub.onNext((Object)ByteBuffer.wrap(this.buffer, 0, len));
                        continue;
                    }
                    this.inputStream.close();
                    this.tryComplete();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.tryComplete(e);
            }
            catch (IOException | ExecutionException e) {
                this.tryComplete(e);
            }
            finally {
                this.publishing.set(false);
            }
        }
    }

    private void tryComplete() {
        this.subscriber.close(Flow.Subscriber::onComplete);
    }

    private void tryComplete(Throwable t) {
        this.subscriber.close(sub -> sub.onError(t));
    }
}

