/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.webserver.IllegalPathPatternException;
import io.helidon.webserver.PathMatcher;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class PathPattern {
    static final PathMatcher.PrefixResult NOT_MATCHED_RESULT = new PathMatcher.PrefixResult(){

        @Override
        public String remainingPart() {
            return null;
        }

        @Override
        public boolean matches() {
            return false;
        }

        @Override
        public Map<String, String> params() {
            return Collections.emptyMap();
        }

        @Override
        public String param(String name) {
            return null;
        }
    };
    private static final char[] REGEXP_META_CHARACTERS = "<([{\\^-=$!|]})?*+.>".toCharArray();
    private static final String PARAM_PREFIX = "gfXdbHQlk";

    private PathPattern() {
    }

    static PathMatcher compile(CharSequence pattern) {
        Objects.requireNonNull(pattern, "Parameter 'pattern' is null!");
        StringBuilder regexp = new StringBuilder(pattern.length() * 2);
        StringBuilder canonical = new StringBuilder(pattern.length());
        boolean isRegexp = false;
        boolean escape = false;
        boolean optionalSequence = false;
        int paramCounter = 0;
        HashMap<String, String> paramToGroupName = new HashMap<String, String>();
        CharIterator iter = new CharIterator(pattern);
        while (iter.hasNext()) {
            char ch = iter.next();
            if (escape) {
                escape = false;
            } else {
                boolean shouldContinue = true;
                switch (ch) {
                    case '\\': {
                        escape = true;
                        break;
                    }
                    case '[': {
                        if (optionalSequence) {
                            throw new IllegalPathPatternException("Optional sequences cannot be nested!", pattern.toString(), iter.index() - 1);
                        }
                        optionalSequence = true;
                        isRegexp = true;
                        regexp.append('(');
                        break;
                    }
                    case ']': {
                        if (optionalSequence) {
                            optionalSequence = false;
                            regexp.append(")?");
                            break;
                        }
                        shouldContinue = false;
                        break;
                    }
                    case '{': {
                        isRegexp = true;
                        String name = PathPattern.parseParameter(iter, regexp, paramCounter);
                        if (name.length() <= 0) break;
                        paramToGroupName.put(name, PARAM_PREFIX + paramCounter);
                        ++paramCounter;
                        break;
                    }
                    default: {
                        shouldContinue = false;
                    }
                }
                if (shouldContinue) continue;
            }
            PathPattern.escapeIfNeeded(ch, regexp);
            canonical.append(ch);
        }
        if (optionalSequence) {
            throw new IllegalPathPatternException("Missing end of a optional sequence (']' character)!", pattern.toString(), iter.index() - 1);
        }
        try {
            if (isRegexp) {
                return new RegexpPathMatcher(regexp.toString(), paramToGroupName);
            }
            return new CanonicalPathMatcher(canonical.toString());
        }
        catch (RuntimeException e) {
            throw new IllegalPathPatternException("Cannot parse generated regular expression!", pattern.toString(), 0);
        }
    }

    private static void escapeIfNeeded(char ch, StringBuilder builder) {
        if (Arrays.binarySearch(REGEXP_META_CHARACTERS, ch) < 0) {
            builder.append(ch);
        } else {
            builder.append('\\').append(ch);
        }
    }

    private static String parseParameter(CharIterator iter, StringBuilder builder, int index) {
        StringBuilder name = new StringBuilder();
        boolean first = true;
        boolean greedy = false;
        while (iter.hasNext()) {
            char ch = iter.next();
            if (first) {
                first = false;
                if ('+' == ch) {
                    greedy = true;
                    continue;
                }
            }
            switch (ch) {
                case ':': {
                    if (greedy) {
                        throw new IllegalPathPatternException("Parameter modifier '+' cannot be combined with custom regexp!", iter.seq.toString(), iter.index() - 1);
                    }
                    String r1 = name.toString().trim();
                    PathPattern.addParamRegexp(builder, r1.length() > 0 ? index : -1, PathPattern.parseParamRegexp(iter));
                    return r1;
                }
                case '}': {
                    String r2 = name.toString().trim();
                    PathPattern.addParamRegexp(builder, r2.length() > 0 ? index : -1, greedy ? ".+" : "[^/]+");
                    return r2;
                }
            }
            name.append(ch);
        }
        throw new IllegalPathPatternException("Pattern parameter has no end character '}'!", iter.seq.toString(), iter.index() - 1);
    }

    private static String parseParamRegexp(CharIterator iter) {
        StringBuilder builder = new StringBuilder();
        int subSeqCounter = 0;
        block4: while (iter.hasNext()) {
            char ch = iter.next();
            switch (ch) {
                case '{': {
                    ++subSeqCounter;
                    continue block4;
                }
                case '}': {
                    if (subSeqCounter > 0) {
                        --subSeqCounter;
                        continue block4;
                    }
                    return builder.toString();
                }
            }
            builder.append(ch);
        }
        throw new IllegalPathPatternException("Pattern parameter has specified regexp but no end character '}'!", iter.seq.toString(), iter.index() - 1);
    }

    private static String addParamRegexp(StringBuilder builder, int nameIndex, String regexp) {
        builder.append("(");
        if (nameIndex >= 0) {
            builder.append("?<").append(PARAM_PREFIX).append(nameIndex).append('>');
        }
        builder.append(regexp);
        builder.append(')');
        return builder.toString();
    }

    static {
        Arrays.sort(REGEXP_META_CHARACTERS);
    }

    static class PositiveResult
    implements PathMatcher.PrefixResult {
        private final Map<String, String> params;
        private final String rightPart;

        PositiveResult(Map<String, String> params, String rightPart) {
            this.params = params == null ? Collections.emptyMap() : Collections.unmodifiableMap(params);
            this.rightPart = rightPart == null ? "" : rightPart;
        }

        PositiveResult(Map<String, String> params) {
            this(params, "");
        }

        @Override
        public boolean matches() {
            return true;
        }

        @Override
        public Map<String, String> params() {
            return this.params;
        }

        @Override
        public String param(String name) {
            return this.params.get(name);
        }

        @Override
        public String remainingPart() {
            return this.rightPart;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PositiveResult that = (PositiveResult)o;
            return Objects.equals(this.params, that.params) && Objects.equals(this.rightPart, that.rightPart);
        }

        public int hashCode() {
            return Objects.hash(this.params, this.rightPart);
        }
    }

    static class RegexpPathMatcher
    implements PathMatcher {
        private static final String RIGHT_PART_PARAM_NAME = "gfXdbHQlkrightpart";
        private final Map<String, String> paramToGroupName;
        private final Pattern pattern;
        private final Pattern leftPattern;

        RegexpPathMatcher(String regexp, Map<String, String> paramToGroupName) {
            Objects.requireNonNull(regexp, "Parameter 'pattern' is null!");
            this.pattern = Pattern.compile(regexp);
            this.leftPattern = Pattern.compile(regexp + "(?<" + RIGHT_PART_PARAM_NAME + ">/.+)?");
            this.paramToGroupName = paramToGroupName == null ? Collections.emptyMap() : new HashMap<String, String>(paramToGroupName);
        }

        @Override
        public PathMatcher.Result match(CharSequence path) {
            Matcher matcher = this.pattern.matcher(path);
            if (matcher.matches()) {
                return new PositiveResult(this.exctractPatternParams(matcher));
            }
            return NOT_MATCHED_RESULT;
        }

        @Override
        public PathMatcher.PrefixResult prefixMatch(CharSequence path) {
            Matcher matcher = this.leftPattern.matcher(path);
            if (matcher.matches()) {
                String rightPart = matcher.group(RIGHT_PART_PARAM_NAME);
                if (rightPart == null || rightPart.isEmpty()) {
                    rightPart = "/";
                }
                if (rightPart.charAt(0) == '/') {
                    return new PositiveResult(this.exctractPatternParams(matcher), rightPart);
                }
                return NOT_MATCHED_RESULT;
            }
            return NOT_MATCHED_RESULT;
        }

        private Map<String, String> exctractPatternParams(Matcher matcher) {
            HashMap<String, String> params = new HashMap<String, String>(this.paramToGroupName.size());
            for (Map.Entry<String, String> entry : this.paramToGroupName.entrySet()) {
                String paramValue = matcher.group(entry.getValue());
                if (paramValue == null) continue;
                params.put(entry.getKey(), paramValue);
            }
            return params;
        }

        public String toString() {
            return "RegexpPathMatcher{pattern=" + this.pattern + '}';
        }
    }

    static class CanonicalPathMatcher
    implements PathMatcher {
        private final String pattern;

        CanonicalPathMatcher(String pattern) {
            Objects.requireNonNull(pattern, "Parameter 'pattern' is null!");
            this.pattern = pattern;
        }

        @Override
        public PathMatcher.Result match(CharSequence path) {
            Objects.requireNonNull(path, "Parameter 'path' is null!");
            if (path.equals(this.pattern)) {
                return new PositiveResult(null);
            }
            return NOT_MATCHED_RESULT;
        }

        @Override
        public PathMatcher.PrefixResult prefixMatch(CharSequence path) {
            Objects.requireNonNull(path, "Parameter 'path' is null!");
            String s = path.toString();
            if (s.startsWith(this.pattern)) {
                String rightPart;
                String string = rightPart = this.pattern.equals("/") ? s : s.substring(this.pattern.length());
                if (rightPart.isEmpty()) {
                    rightPart = "/";
                }
                if (rightPart.charAt(0) == '/') {
                    return new PositiveResult(null, rightPart);
                }
                return NOT_MATCHED_RESULT;
            }
            return NOT_MATCHED_RESULT;
        }

        public String toString() {
            return "CanonicalPathMatcher{pattern='" + this.pattern + '\'' + '}';
        }
    }

    private static class CharIterator {
        private final CharSequence seq;
        private int index = 0;

        CharIterator(CharSequence seq) {
            this.seq = seq;
        }

        boolean hasNext() {
            return this.seq.length() > this.index;
        }

        char next() {
            if (this.hasNext()) {
                return this.seq.charAt(this.index++);
            }
            return '\u0000';
        }

        int index() {
            return this.index;
        }
    }
}

