/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.reactive.Flow;
import io.helidon.webserver.HashResponseHeaders;
import io.opentracing.Span;
import java.util.Objects;

class SendHeadersFirstPublisher<T>
implements Flow.Publisher<T> {
    private final Object lock = new Object();
    private final HashResponseHeaders headers;
    private final Flow.Publisher<T> delegate;
    private final Span span;
    private boolean sent;
    private volatile boolean sentVolatile;
    private volatile Flow.Subscriber<? super T> singleSubscriber;

    SendHeadersFirstPublisher(HashResponseHeaders headers, Span span, Flow.Publisher<T> delegate) {
        Objects.requireNonNull(delegate, "Parameter 'delegate' is null!");
        this.headers = headers;
        this.span = span;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        boolean hasSubscriber;
        boolean bl = hasSubscriber = this.singleSubscriber != null;
        if (!hasSubscriber) {
            Object object = this.lock;
            synchronized (object) {
                boolean bl2 = hasSubscriber = this.singleSubscriber != null;
                if (!hasSubscriber) {
                    this.singleSubscriber = subscriber;
                }
            }
        }
        if (hasSubscriber) {
            subscriber.onError((Throwable)new IllegalStateException("Only single subscriber is allowed!"));
            return;
        }
        DelegatingSubscriber ds = new DelegatingSubscriber(subscriber);
        this.delegate.subscribe((Flow.Subscriber)ds);
    }

    private class DelegatingSubscriber
    implements Flow.Subscriber<T> {
        private final Flow.Subscriber<? super T> delegate;

        DelegatingSubscriber(Flow.Subscriber<? super T> delegate) {
            this.delegate = delegate;
        }

        public void onSubscribe(Flow.Subscription subscription) {
            this.delegate.onSubscribe(subscription);
        }

        public void onNext(T item) {
            this.sendHeadersIfNeeded();
            this.delegate.onNext(item);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendHeadersIfNeeded() {
            if (SendHeadersFirstPublisher.this.headers != null && !SendHeadersFirstPublisher.this.sent && !SendHeadersFirstPublisher.this.sentVolatile) {
                DelegatingSubscriber delegatingSubscriber = this;
                synchronized (delegatingSubscriber) {
                    if (!SendHeadersFirstPublisher.this.sent && !SendHeadersFirstPublisher.this.sentVolatile) {
                        SendHeadersFirstPublisher.this.sent = true;
                        SendHeadersFirstPublisher.this.sentVolatile = true;
                        SendHeadersFirstPublisher.this.headers.send();
                    }
                }
            }
        }

        public void onError(Throwable throwable) {
            try {
                this.delegate.onError(throwable);
            }
            finally {
                if (SendHeadersFirstPublisher.this.span != null) {
                    SendHeadersFirstPublisher.this.span.finish();
                }
            }
        }

        public void onComplete() {
            try {
                this.sendHeadersIfNeeded();
                if (SendHeadersFirstPublisher.this.span != null) {
                    SendHeadersFirstPublisher.this.span.finish();
                }
                this.delegate.onComplete();
            }
            catch (Exception e) {
                if (SendHeadersFirstPublisher.this.span != null) {
                    SendHeadersFirstPublisher.this.span.finish();
                }
                throw e;
            }
        }
    }
}

