/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.CollectionsHelper;
import io.helidon.common.context.Context;
import io.helidon.common.http.ContextualRegistry;
import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.webserver.ExperimentalConfiguration;
import io.helidon.webserver.Http2Configuration;
import io.helidon.webserver.SSLContextBuilder;
import io.helidon.webserver.ServerBasicConfig;
import io.helidon.webserver.SocketConfiguration;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;

public interface ServerConfiguration
extends SocketConfiguration {
    public static final String DEFAULT_SOCKET_NAME = "@default";

    public int workersCount();

    @Override
    public int port();

    @Override
    public InetAddress bindAddress();

    @Override
    public int backlog();

    @Override
    public int timeoutMillis();

    @Override
    public int receiveBufferSize();

    @Override
    public SSLContext ssl();

    default public SocketConfiguration socket(String name) {
        return Optional.ofNullable(this.sockets()).map(map -> (SocketConfiguration)map.get(name)).orElse(null);
    }

    public Map<String, SocketConfiguration> sockets();

    public Tracer tracer();

    public Context context();

    public ExperimentalConfiguration experimental();

    default public boolean isHttp2Enabled() {
        ExperimentalConfiguration experimental = this.experimental();
        return experimental != null && experimental.http2() != null && experimental.http2().enable();
    }

    public static ServerConfiguration create(Config config) {
        return ServerConfiguration.builder(config).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Config config) {
        return new Builder().config(config);
    }

    public static final class Builder
    implements io.helidon.common.Builder<ServerConfiguration> {
        private static final AtomicInteger WEBSERVER_COUNTER = new AtomicInteger(1);
        private final SocketConfiguration.Builder defaultSocketBuilder = SocketConfiguration.builder();
        private final Map<String, SocketConfiguration> sockets = new HashMap<String, SocketConfiguration>();
        private int workers;
        private Tracer tracer;
        private ExperimentalConfiguration experimental;
        private ContextualRegistry context;

        private Builder() {
        }

        public Builder ssl(SSLContext sslContext) {
            this.defaultSocketBuilder.ssl(sslContext);
            return this;
        }

        public Builder ssl(Supplier<? extends SSLContext> sslContextBuilder) {
            this.defaultSocketBuilder.ssl(sslContextBuilder);
            return this;
        }

        public Builder port(int port) {
            this.defaultSocketBuilder.port(port);
            return this;
        }

        public Builder bindAddress(InetAddress bindAddress) {
            this.defaultSocketBuilder.bindAddress(bindAddress);
            return this;
        }

        public Builder backlog(int size) {
            this.defaultSocketBuilder.backlog(size);
            return this;
        }

        public Builder timeout(int milliseconds) {
            this.defaultSocketBuilder.timeoutMillis(milliseconds);
            return this;
        }

        public Builder receiveBufferSize(int bytes) {
            this.defaultSocketBuilder.receiveBufferSize(bytes);
            return this;
        }

        public Builder addSocket(String name, int port, InetAddress bindAddress) {
            Objects.requireNonNull(name, "Parameter 'name' must not be null!");
            return this.addSocket(name, (Supplier<SocketConfiguration>)((Object)SocketConfiguration.builder().port(port).bindAddress(bindAddress)));
        }

        public Builder addSocket(String name, SocketConfiguration socketConfiguration) {
            Objects.requireNonNull(name, "Parameter 'name' must not be null!");
            this.sockets.put(name, socketConfiguration != null ? socketConfiguration : SocketConfiguration.DEFAULT);
            return this;
        }

        public Builder addSocket(String name, Supplier<SocketConfiguration> socketConfigurationBuilder) {
            Objects.requireNonNull(name, "Parameter 'name' must not be null!");
            return this.addSocket(name, socketConfigurationBuilder != null ? socketConfigurationBuilder.get() : null);
        }

        public Builder workersCount(int workers) {
            this.workers = workers;
            return this;
        }

        public Builder tracer(Tracer tracer) {
            this.tracer = tracer;
            return this;
        }

        public Builder tracer(Supplier<? extends Tracer> tracerBuilder) {
            return this.tracer(tracerBuilder.get());
        }

        public Builder enabledSSlProtocols(String ... protocols) {
            this.defaultSocketBuilder.enabledSSlProtocols(protocols);
            return this;
        }

        public Builder enabledSSlProtocols(List<String> protocols) {
            this.defaultSocketBuilder.enabledSSlProtocols(protocols);
            return this;
        }

        public Builder experimental(ExperimentalConfiguration experimental) {
            this.experimental = experimental;
            return this;
        }

        public Builder context(Context context) {
            this.context = ContextualRegistry.builder().id(context.id() + ":web-" + WEBSERVER_COUNTER.getAndIncrement()).parent(context).build();
            return this;
        }

        private InetAddress string2InetAddress(String address) {
            try {
                return InetAddress.getByName(address);
            }
            catch (UnknownHostException e) {
                throw new ConfigException("Illegal value of 'bind-address' configuration key. Expecting host or ip address!", (Throwable)e);
            }
        }

        public Builder config(Config config) {
            Config experimentalConfig;
            if (config == null) {
                return this;
            }
            this.configureSocket(config, this.defaultSocketBuilder);
            config.get("workers").asInt().ifPresent(this::workersCount);
            Config socketsConfig = config.get("sockets");
            if (socketsConfig.exists()) {
                for (Config socketConfig : (List)socketsConfig.asNodeList().orElse((Object)CollectionsHelper.listOf())) {
                    String socketName = socketConfig.name();
                    this.sockets.put(socketName, this.configureSocket(socketConfig, SocketConfiguration.builder()).build());
                }
            }
            if ((experimentalConfig = config.get("experimental")).exists()) {
                ExperimentalConfiguration.Builder experimentalBuilder = new ExperimentalConfiguration.Builder();
                Config http2Config = experimentalConfig.get("http2");
                if (http2Config.exists()) {
                    Http2Configuration.Builder http2Builder = new Http2Configuration.Builder();
                    http2Config.get("enable").asBoolean().ifPresent(http2Builder::enable);
                    http2Config.get("max-content-length").asInt().ifPresent(http2Builder::maxContentLength);
                    experimentalBuilder.http2(http2Builder.build());
                }
                this.experimental = experimentalBuilder.build();
            }
            return this;
        }

        private SocketConfiguration.Builder configureSocket(Config config, SocketConfiguration.Builder soConfigBuilder) {
            config.get("port").asInt().ifPresent(soConfigBuilder::port);
            config.get("bind-address").asString().map(this::string2InetAddress).ifPresent(soConfigBuilder::bindAddress);
            config.get("backlog").asInt().ifPresent(soConfigBuilder::backlog);
            config.get("timeout").asInt().ifPresent(soConfigBuilder::timeoutMillis);
            config.get("receive-buffer").asInt().ifPresent(soConfigBuilder::receiveBufferSize);
            config.get("ssl-protocols").asList(String.class).ifPresent(soConfigBuilder::enabledSSlProtocols);
            Config sslConfig = config.get("ssl");
            if (sslConfig.exists()) {
                try {
                    soConfigBuilder.ssl(SSLContextBuilder.create(sslConfig));
                }
                catch (IllegalStateException e) {
                    throw new ConfigException("Cannot load SSL configuration.", (Throwable)e);
                }
            }
            return soConfigBuilder;
        }

        public ServerConfiguration build() {
            if (null == this.context) {
                this.context = ContextualRegistry.builder().id("web-" + WEBSERVER_COUNTER.getAndIncrement()).build();
            }
            Optional maybeTracer = this.context.get(Tracer.class);
            if (null == this.tracer) {
                this.tracer = maybeTracer.orElseGet(GlobalTracer::get);
            }
            if (!maybeTracer.isPresent()) {
                this.context.register((Object)this.tracer);
            }
            if (this.workers <= 0) {
                this.workers = Runtime.getRuntime().availableProcessors();
            }
            if (null == this.experimental) {
                this.experimental = ExperimentalConfiguration.builder().build();
            }
            return new ServerBasicConfig(this);
        }

        SocketConfiguration.Builder defaultSocketBuilder() {
            return this.defaultSocketBuilder;
        }

        Map<String, SocketConfiguration> sockets() {
            return this.sockets;
        }

        int workers() {
            return this.workers;
        }

        Tracer tracer() {
            return this.tracer;
        }

        ExperimentalConfiguration experimental() {
            return this.experimental;
        }

        ContextualRegistry context() {
            return this.context;
        }
    }
}

