/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.http.DataChunk;
import io.helidon.common.reactive.BufferedEmittingPublisher;
import io.helidon.common.reactive.Multi;
import io.helidon.webserver.ByteBufRequestChunk;
import io.helidon.webserver.ReferenceHoldingQueue;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.Flow;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;

class HttpRequestScopedPublisher
extends BufferedEmittingPublisher<DataChunk> {
    private static final Logger LOGGER = Logger.getLogger(HttpRequestScopedPublisher.class.getName());
    private final ReentrantReadWriteLock.WriteLock lock = new ReentrantReadWriteLock().writeLock();
    private final ReferenceHoldingQueue<DataChunk> referenceQueue;

    HttpRequestScopedPublisher(ChannelHandlerContext ctx, ReferenceHoldingQueue<DataChunk> referenceQueue) {
        this.referenceQueue = referenceQueue;
        super.onRequest((n, demand) -> {
            if (super.isUnbounded()) {
                LOGGER.finest("Netty autoread: true");
                ctx.channel().config().setAutoRead(true);
            } else {
                LOGGER.finest("Netty autoread: false");
                ctx.channel().config().setAutoRead(false);
            }
            try {
                this.lock.lock();
                if (super.hasRequests()) {
                    LOGGER.finest("Requesting next chunks from Netty.");
                    ctx.channel().read();
                } else {
                    LOGGER.finest("No hook action required.");
                }
            }
            finally {
                this.lock.unlock();
            }
        });
    }

    public int emit(ByteBuf data) {
        try {
            int n = super.emit((Object)new ByteBufRequestChunk(data, this.referenceQueue));
            return n;
        }
        finally {
            this.referenceQueue.release();
        }
    }

    public void clearAndRelease() {
        Multi.create((Flow.Publisher)((Object)this)).forEach(DataChunk::release).onTerminate(() -> super.clearBuffer(DataChunk::release));
    }

    public void complete() {
        try {
            super.complete();
        }
        finally {
            this.referenceQueue.release();
        }
    }

    public void fail(Throwable throwable) {
        try {
            super.fail(throwable);
        }
        finally {
            this.referenceQueue.release();
        }
    }
}

