/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Http;
import io.helidon.common.reactive.Single;
import io.helidon.webserver.BareResponse;
import io.helidon.webserver.SocketClosedException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.logging.Logger;

class BareResponseImpl
implements BareResponse {
    private static final Logger LOGGER = Logger.getLogger(BareResponseImpl.class.getName());
    private static final String HTTP_2_HEADER_PREFIX = "x-http2";
    private static final String HTTP_2_STREAM_ID = "x-http2-stream-id";
    private static final SocketClosedException CLOSED = new SocketClosedException("Response channel is closed!");
    private final boolean keepAlive;
    private final ChannelHandlerContext ctx;
    private final AtomicBoolean statusHeadersSent = new AtomicBoolean(false);
    private final AtomicBoolean internallyClosed = new AtomicBoolean(false);
    private final CompletableFuture<BareResponse> responseFuture;
    private final CompletableFuture<BareResponse> headersFuture;
    private final BooleanSupplier requestContentConsumed;
    private final long requestId;
    private final String http2StreamId;
    private final HttpHeaders requestHeaders;
    private final ChannelFuture channelClosedFuture;
    private final GenericFutureListener<? extends Future<? super Void>> channelClosedListener;
    private Flow.Subscription subscription;
    private DataChunk firstChunk;
    private CompletableFuture<?> prevRequestChunk;
    private volatile boolean lengthOptimization;
    private volatile boolean isWebSocketUpgrade = false;
    private volatile DefaultHttpResponse response;

    BareResponseImpl(ChannelHandlerContext ctx, HttpRequest request, BooleanSupplier requestContentConsumed, CompletableFuture<?> prevRequestChunk, long requestId) {
        this.requestContentConsumed = requestContentConsumed;
        this.responseFuture = new CompletableFuture();
        this.headersFuture = new CompletableFuture();
        this.ctx = ctx;
        this.requestId = requestId;
        this.keepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
        this.requestHeaders = request.headers();
        this.prevRequestChunk = prevRequestChunk;
        this.http2StreamId = this.requestHeaders.get(HTTP_2_STREAM_ID);
        this.channelClosedListener = this::channelClosed;
        this.channelClosedFuture = ctx.channel().closeFuture();
        this.channelClosedFuture.addListener(this.channelClosedListener);
        this.responseFuture.whenComplete(this::responseComplete);
    }

    private void responseComplete(BareResponse self, Throwable throwable) {
        if (throwable == null) {
            this.headersFuture.complete(this);
        } else {
            this.headersFuture.completeExceptionally(throwable);
        }
        this.channelClosedFuture.removeListener(this.channelClosedListener);
    }

    private void channelClosed(Future<? super Void> future) {
        this.responseFuture.completeExceptionally(CLOSED);
    }

    @Override
    public void writeStatusAndHeaders(Http.ResponseStatus status, Map<String, List<String>> headers) {
        Objects.requireNonNull(status, "Parameter 'statusCode' was null!");
        if (!this.statusHeadersSent.compareAndSet(false, true)) {
            throw new IllegalStateException("Status and headers were already sent");
        }
        this.response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)status.code()));
        for (Map.Entry<String, List<String>> headerEntry : headers.entrySet()) {
            this.response.headers().add(headerEntry.getKey(), (Iterable)headerEntry.getValue());
        }
        this.requestHeaders.names().stream().filter(header -> header.startsWith(HTTP_2_HEADER_PREFIX)).forEach(header -> this.response.headers().add(header, (Object)this.requestHeaders.get(header)));
        boolean isUpgrade = this.isWebSocketUpgrade(status, headers);
        if (isUpgrade) {
            this.isWebSocketUpgrade = true;
        } else {
            boolean lengthSet = HttpUtil.isContentLengthSet((HttpMessage)this.response);
            if (!lengthSet) {
                this.lengthOptimization = status.code() == Http.Status.OK_200.code() && !HttpUtil.isTransferEncodingChunked((HttpMessage)this.response);
                HttpUtil.setTransferEncodingChunked((HttpMessage)this.response, (boolean)true);
            }
        }
        if (this.keepAlive && !headers.containsKey(HttpHeaderNames.CONNECTION.toString())) {
            this.response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        if (!this.lengthOptimization) {
            LOGGER.fine(() -> this.log("Writing headers %s", status));
            this.orderedWrite(this::initWriteResponse);
        }
    }

    private boolean isWebSocketUpgrade(Http.ResponseStatus status, Map<String, List<String>> headers) {
        return status.code() == 101 && headers.containsKey("Upgrade") && headers.get("Upgrade").contains("websocket");
    }

    boolean isWebSocketUpgrade() {
        return this.isWebSocketUpgrade;
    }

    private void completeResponseFuture(Throwable throwable) {
        if (throwable == null) {
            this.responseFuture.complete(this);
        } else {
            LOGGER.finer(() -> this.log("Response completion failed %s", throwable));
            this.internallyClosed.set(true);
            this.responseFuture.completeExceptionally(throwable);
        }
    }

    private void completeInternal(Throwable throwable) {
        boolean wasClosed = !this.internallyClosed.compareAndSet(false, true);
        this.orderedWrite(() -> this.completeInternalPipe(wasClosed, throwable));
    }

    private void completeInternalPipe(boolean wasClosed, Throwable throwable) {
        if (wasClosed) {
            this.completeResponseFuture(throwable);
            return;
        }
        if (this.keepAlive) {
            LOGGER.finest(() -> this.log("Writing an empty last http content; keep-alive: true", new Object[0]));
            this.writeLastContent(throwable, ChannelFutureListener.CLOSE_ON_FAILURE);
            if (!this.requestContentConsumed.getAsBoolean()) {
                LOGGER.finer(() -> this.log("Request content not fully read with keep-alive: true", this.ctx));
                this.ctx.channel().read();
            }
        } else {
            LOGGER.finest(() -> this.log("Closing with an empty buffer; keep-alive: false", this.ctx));
            this.writeLastContent(throwable, ChannelFutureListener.CLOSE);
        }
    }

    private void writeLastContent(Throwable throwable, ChannelFutureListener closeAction) {
        boolean chunked = true;
        if (this.lengthOptimization) {
            if (this.firstChunk != null) {
                if (throwable == null) {
                    HttpUtil.setTransferEncodingChunked((HttpMessage)this.response, (boolean)false);
                    HttpUtil.setContentLength((HttpMessage)this.response, (long)this.firstChunk.remaining());
                    chunked = false;
                } else {
                    this.response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
                    this.response.headers().set((CharSequence)HttpHeaderNames.TRAILER, (Object)"stream-status,stream-result");
                }
            }
            this.initWriteResponse();
        }
        DefaultLastHttpContent lastHttpContent = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER);
        if (chunked && throwable != null) {
            lastHttpContent.trailingHeaders().set("stream-status", (Object)500).set("stream-result", (Object)throwable);
            LOGGER.severe(() -> this.log("Upstream error while sending response: %s", throwable));
        }
        this.ctx.writeAndFlush((Object)lastHttpContent).addListener(this.completeOnFailureListener("An exception occurred when writing last http content.")).addListener(this.completeOnSuccessListener(throwable)).addListener((GenericFutureListener)closeAction);
    }

    private GenericFutureListener<Future<? super Void>> completeOnFailureListener(String message) {
        return future -> {
            if (!future.isSuccess()) {
                this.completeResponseFuture(new IllegalStateException(message, future.cause()));
                LOGGER.finest(() -> this.log("Failure listener: " + future.cause(), new Object[0]));
            }
        };
    }

    private GenericFutureListener<Future<? super Void>> completeOnSuccessListener(Throwable throwable) {
        return future -> {
            if (future.isSuccess()) {
                this.completeResponseFuture(throwable);
                LOGGER.finest(() -> this.log("Last http message flushed", this.ctx));
            }
        };
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.subscription = subscription;
        subscription.request(Long.MAX_VALUE);
    }

    @Override
    public void onNext(DataChunk data) {
        if (this.internallyClosed.get()) {
            throw new IllegalStateException("Response is already closed!");
        }
        if (data != null) {
            if (data.isFlushChunk()) {
                if (this.prevRequestChunk == null) {
                    this.ctx.flush();
                } else {
                    this.prevRequestChunk = this.prevRequestChunk.thenRun(() -> ((ChannelHandlerContext)this.ctx).flush());
                }
                return;
            }
            if (this.lengthOptimization && this.firstChunk == null) {
                this.firstChunk = data.isReadOnly() ? data : data.duplicate();
                return;
            }
            this.orderedWrite(() -> this.onNextPipe(data));
        }
    }

    private void onNextPipe(DataChunk data) {
        if (this.lengthOptimization) {
            this.initWriteResponse();
        }
        this.sendData(data);
    }

    private ChannelFuture initWriteResponse() {
        ChannelFuture cf = this.ctx.write((Object)this.response).addListener(future -> {
            if (future.isSuccess()) {
                this.headersFuture.complete(this);
            }
        }).addListener(this.completeOnFailureListener("An exception occurred when writing headers.")).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
        this.response = null;
        if (this.firstChunk != null) {
            cf = this.sendData(this.firstChunk);
            this.firstChunk = null;
        }
        this.lengthOptimization = false;
        return cf;
    }

    private ChannelFuture sendData(DataChunk data) {
        DefaultHttpContent httpContent;
        LOGGER.finest(() -> this.log("Sending data chunk", new Object[0]));
        if (data.isBackedBy(ByteBuf.class)) {
            ByteBuf[] byteBufs = (ByteBuf[])data.data(ByteBuf.class);
            if (byteBufs.length == 1) {
                httpContent = new DefaultHttpContent(byteBufs[0].retain());
            } else {
                for (ByteBuf byteBuf : byteBufs) {
                    byteBuf.retain();
                }
                httpContent = new DefaultHttpContent(Unpooled.wrappedBuffer((ByteBuf[])byteBufs));
            }
        } else {
            httpContent = new DefaultHttpContent(Unpooled.wrappedBuffer((ByteBuffer[])data.data()));
        }
        LOGGER.finest(() -> this.log("Sending data chunk on event loop thread", this.ctx));
        ChannelFuture channelFuture = data.flush() ? this.ctx.writeAndFlush((Object)httpContent) : this.ctx.write((Object)httpContent);
        return channelFuture.addListener(future -> {
            data.writeFuture().ifPresent(writeFuture -> {
                if (future.isSuccess()) {
                    writeFuture.complete(data);
                } else {
                    writeFuture.completeExceptionally(future.cause());
                }
            });
            data.release();
            LOGGER.finest(() -> this.log("Data chunk sent with result: %s", future.isSuccess()));
        }).addListener(this.completeOnFailureListener("Failure when sending a content!")).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
    }

    @Override
    public void onError(Throwable thr) {
        this.completeInternal(thr);
        if (this.subscription != null) {
            this.subscription.cancel();
        }
    }

    @Override
    public void onComplete() {
        this.completeInternal(null);
        if (this.subscription != null) {
            this.subscription.cancel();
        }
    }

    @Override
    public Single<BareResponse> whenCompleted() {
        return Single.create(this.responseFuture);
    }

    @Override
    public Single<BareResponse> whenHeadersCompleted() {
        return Single.create(this.headersFuture);
    }

    @Override
    public long requestId() {
        return this.requestId;
    }

    private CompletableFuture<?> orderedWrite(Runnable runnable) {
        if (this.prevRequestChunk == null) {
            runnable.run();
        } else {
            this.prevRequestChunk = this.prevRequestChunk.thenRun(runnable);
        }
        return this.prevRequestChunk;
    }

    private String log(String template, Object ... params) {
        ArrayList<Object> list = new ArrayList<Object>(params.length + 3);
        list.add(System.identityHashCode(this));
        list.add(this.ctx != null ? Integer.valueOf(System.identityHashCode(this.ctx.channel())) : "N/A");
        list.add(this.http2StreamId != null ? this.http2StreamId : "N/A");
        list.addAll(Arrays.asList(params));
        return String.format("[Response: %s, Channel: %s, StreamID: %s] " + template, list.toArray());
    }
}

