/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.webserver.KeyPerformanceIndicatorSupport;

class KeyPerformanceIndicatorContextFactory {
    static KeyPerformanceIndicatorSupport.Context immediateRequestContext() {
        return new ImmediateRequestContext();
    }

    static DeferrableRequestContext deferrableRequestContext() {
        return new DeferrableRequestContext();
    }

    private KeyPerformanceIndicatorContextFactory() {
    }

    private static class DeferrableRequestContext
    extends ImmediateRequestContext
    implements KeyPerformanceIndicatorSupport.DeferrableRequestContext {
        private DeferrableRequestContext() {
        }

        @Override
        public void requestHandlingStarted(KeyPerformanceIndicatorSupport.Metrics kpiMetrics) {
            this.kpiMetrics(kpiMetrics);
            kpiMetrics.onRequestReceived();
        }

        @Override
        public void requestProcessingStarted() {
            this.recordStartTime();
            KeyPerformanceIndicatorSupport.Metrics kpiMetrics = this.kpiMetrics();
            if (kpiMetrics != null) {
                this.kpiMetrics().onRequestStarted();
            }
        }
    }

    private static class ImmediateRequestContext
    implements KeyPerformanceIndicatorSupport.Context {
        private KeyPerformanceIndicatorSupport.Metrics kpiMetrics;
        private long requestStartTime;

        private ImmediateRequestContext() {
        }

        @Override
        public void requestHandlingStarted(KeyPerformanceIndicatorSupport.Metrics kpiMetrics) {
            this.recordStartTime();
            this.kpiMetrics(kpiMetrics);
            kpiMetrics.onRequestReceived();
            kpiMetrics.onRequestStarted();
        }

        @Override
        public void requestProcessingCompleted(boolean isSuccessful) {
            if (this.kpiMetrics != null) {
                this.kpiMetrics.onRequestCompleted(isSuccessful, System.currentTimeMillis() - this.requestStartTime);
            }
        }

        protected void recordStartTime() {
            this.requestStartTime = System.currentTimeMillis();
        }

        protected void kpiMetrics(KeyPerformanceIndicatorSupport.Metrics kpiMetrics) {
            this.kpiMetrics = kpiMetrics;
        }

        protected KeyPerformanceIndicatorSupport.Metrics kpiMetrics() {
            return this.kpiMetrics;
        }
    }
}

