/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.GenericType;
import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.common.http.Http;
import io.helidon.common.http.HttpRequest;
import io.helidon.common.http.MediaType;
import io.helidon.common.http.Parameters;
import io.helidon.common.http.ReadOnlyParameters;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.MessageBodyContext;
import io.helidon.media.common.MessageBodyReadableContent;
import io.helidon.media.common.MessageBodyReaderContext;
import io.helidon.tracing.config.SpanTracingConfig;
import io.helidon.tracing.config.TracingConfigUtil;
import io.helidon.webserver.BareRequest;
import io.helidon.webserver.HashRequestHeaders;
import io.helidon.webserver.RequestHeaders;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.UriComponent;
import io.helidon.webserver.WebServer;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;

abstract class Request
implements ServerRequest {
    private static final String TRACING_CONTENT_READ_NAME = "content-read";
    static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final BareRequest bareRequest;
    private final WebServer webServer;
    private final Context context;
    private final Parameters queryParams;
    private final HashRequestHeaders headers;
    private final MessageBodyReadableContent content;
    private final MessageBodyEventListener eventListener;

    Request(BareRequest req, WebServer webServer, HashRequestHeaders headers) {
        this.bareRequest = req;
        this.webServer = webServer;
        this.headers = headers;
        this.context = Contexts.context().orElseGet(() -> Context.create((Context)webServer.context()));
        this.queryParams = UriComponent.decodeQuery(req.uri().getRawQuery(), true);
        this.eventListener = new MessageBodyEventListener();
        MessageBodyReaderContext readerContext = MessageBodyReaderContext.create((MessageBodyReaderContext)webServer.readerContext(), (MessageBodyContext.EventListener)this.eventListener, (ReadOnlyParameters)headers, headers.contentType());
        this.content = MessageBodyReadableContent.create(req.bodyPublisher(), (MessageBodyReaderContext)readerContext);
    }

    Request(Request request) {
        this.bareRequest = request.bareRequest;
        this.webServer = request.webServer;
        this.context = request.context;
        this.queryParams = request.queryParams;
        this.headers = request.headers;
        this.content = request.content;
        this.eventListener = request.eventListener;
    }

    static Charset contentCharset(ServerRequest request) {
        return request.headers().contentType().flatMap(MediaType::charset).map(Charset::forName).orElse(DEFAULT_CHARSET);
    }

    @Override
    public WebServer webServer() {
        return this.webServer;
    }

    @Override
    public Context context() {
        return this.context;
    }

    public Http.RequestMethod method() {
        return this.bareRequest.method();
    }

    public Http.Version version() {
        return this.bareRequest.version();
    }

    public URI uri() {
        return this.bareRequest.uri();
    }

    public String query() {
        return this.bareRequest.uri().getRawQuery();
    }

    public Parameters queryParams() {
        return this.queryParams;
    }

    public String fragment() {
        return this.bareRequest.uri().getFragment();
    }

    @Override
    public String localAddress() {
        return this.bareRequest.localAddress();
    }

    @Override
    public int localPort() {
        return this.bareRequest.localPort();
    }

    @Override
    public String remoteAddress() {
        return this.bareRequest.remoteAddress();
    }

    @Override
    public int remotePort() {
        return this.bareRequest.remotePort();
    }

    @Override
    public boolean isSecure() {
        return this.bareRequest.isSecure();
    }

    @Override
    public RequestHeaders headers() {
        return this.headers;
    }

    @Override
    public MessageBodyReadableContent content() {
        return this.content;
    }

    @Override
    public long requestId() {
        return this.bareRequest.requestId();
    }

    @Override
    public Single<Void> closeConnection() {
        return this.bareRequest.closeConnection();
    }

    static class Path
    implements HttpRequest.Path {
        private final String path;
        private final String rawPath;
        private final Map<String, String> params;
        private final Path absolutePath;
        private List<String> segments;

        Path(String path, String rawPath, Map<String, String> params, Path absolutePath) {
            this.path = path;
            this.rawPath = rawPath;
            this.params = params == null ? Collections.emptyMap() : params;
            this.absolutePath = absolutePath;
        }

        public String param(String name) {
            return this.params.get(name);
        }

        public List<String> segments() {
            List<String> result = this.segments;
            if (result == null) {
                StringTokenizer stok = new StringTokenizer(this.path, "/");
                result = new ArrayList<String>();
                while (stok.hasMoreTokens()) {
                    result.add(stok.nextToken());
                }
                this.segments = result;
            }
            return result;
        }

        public String toString() {
            return this.path;
        }

        public String toRawString() {
            return this.rawPath;
        }

        public Path absolute() {
            return this.absolutePath == null ? this : this.absolutePath;
        }

        static Path create(Path contextual, String path, Map<String, String> params) {
            return Path.create(contextual, path, path, params);
        }

        static Path create(Path contextual, String path, String rawPath, Map<String, String> params) {
            if (contextual == null) {
                return new Path(path, rawPath, params, null);
            }
            return contextual.createSubpath(path, rawPath, params);
        }

        Path createSubpath(String path, String rawPath, Map<String, String> params) {
            if (params == null) {
                params = Collections.emptyMap();
            }
            if (this.absolutePath == null) {
                HashMap<String, String> map = new HashMap<String, String>(this.params.size() + params.size());
                map.putAll(this.params);
                map.putAll(params);
                return new Path(path, rawPath, params, new Path(this.path, this.rawPath, map, null));
            }
            int size = this.params.size() + params.size() + this.absolutePath.params.size();
            HashMap<String, String> map = new HashMap<String, String>(size);
            map.putAll(this.absolutePath.params);
            map.putAll(this.params);
            map.putAll(params);
            return new Path(path, rawPath, params, new Path(this.absolutePath.path, this.absolutePath.rawPath, map, null));
        }
    }

    private final class MessageBodyEventListener
    implements MessageBodyContext.EventListener {
        private Span readSpan;

        private MessageBodyEventListener() {
        }

        private Span createReadSpan(GenericType<?> type) {
            Optional<SpanContext> parentSpan = Request.this.spanContext();
            if (parentSpan.isEmpty()) {
                return null;
            }
            SpanTracingConfig spanConfig = TracingConfigUtil.spanConfig((String)"web-server", (String)Request.TRACING_CONTENT_READ_NAME, (Context)Request.this.context());
            String spanName = spanConfig.newName().orElse(Request.TRACING_CONTENT_READ_NAME);
            if (spanConfig.enabled()) {
                Tracer.SpanBuilder spanBuilder = Request.this.tracer().buildSpan(spanName);
                spanBuilder.asChildOf(parentSpan.get());
                if (type != null) {
                    spanBuilder.withTag("requested.type", type.getTypeName());
                }
                return spanBuilder.start();
            }
            return null;
        }

        public void onEvent(MessageBodyContext.Event event) {
            switch (event.eventType()) {
                case BEFORE_ONSUBSCRIBE: {
                    GenericType type = event.entityType().orElse(null);
                    this.readSpan = this.createReadSpan(type);
                    break;
                }
                case AFTER_ONERROR: {
                    if (this.readSpan == null) break;
                    Tags.ERROR.set(this.readSpan, Boolean.TRUE);
                    Throwable ex = event.asErrorEvent().error();
                    this.readSpan.log(Map.of("event", "error", "error.kind", "Exception", "error.object", ex, "message", ex.toString()));
                    this.readSpan.finish();
                    break;
                }
                case AFTER_ONCOMPLETE: {
                    if (this.readSpan == null) break;
                    this.readSpan.finish();
                    break;
                }
            }
        }
    }
}

