/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.AbstractInboundHttp2ToHttpAdapterBuilder;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapter;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapterBuilder;

class InboundHttp2ToHttpAdapterWrapper
extends InboundHttp2ToHttpAdapter {
    protected InboundHttp2ToHttpAdapterWrapper(Http2Connection connection, int maxContentLength, boolean validateHttpHeaders, boolean propagateSettings) {
        super(connection, maxContentLength, validateHttpHeaders, propagateSettings);
    }

    protected FullHttpMessage newMessage(Http2Stream stream, Http2Headers headers, boolean validateHttpHeaders, ByteBufAllocator alloc) throws Http2Exception {
        FullHttpMessage fullHttpMessage = super.newMessage(stream, headers, validateHttpHeaders, alloc);
        fullHttpMessage.setProtocolVersion(new HttpVersion("HTTP", 2, 0, true));
        return fullHttpMessage;
    }

    static InboundHttp2ToHttpAdapter create(Http2Connection connection, int maxContentLength, boolean validateHttpHeaders, boolean propagateSettings) {
        return new Builder(connection, maxContentLength, validateHttpHeaders, propagateSettings).build();
    }

    private static class Builder
    extends AbstractInboundHttp2ToHttpAdapterBuilder<InboundHttp2ToHttpAdapter, InboundHttp2ToHttpAdapterBuilder> {
        protected Builder(Http2Connection connection, int maxContentLength, boolean validateHttpHeaders, boolean propagateSettings) {
            super(connection);
            super.maxContentLength(maxContentLength);
            super.validateHttpHeaders(validateHttpHeaders);
            super.propagateSettings(propagateSettings);
        }

        public InboundHttp2ToHttpAdapter build() {
            return super.build();
        }

        protected InboundHttp2ToHttpAdapter build(Http2Connection connection, int maxContentLength, boolean validateHttpHeaders, boolean propagateSettings) throws Exception {
            return new InboundHttp2ToHttpAdapterWrapper(connection, maxContentLength, validateHttpHeaders, propagateSettings);
        }
    }
}

