/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import java.util.logging.Logger;

class NettyInitializer {
    private static final Logger LOGGER = Logger.getLogger(NettyInitializer.class.getName());
    private static final String HELIDON_MAXORDER_DEFAULT = "6";
    private static final String NETTY_MAXORDER_PROPERTY = "io.netty.allocator.maxOrder";

    private NettyInitializer() {
    }

    static String getMaxOrderProperty() {
        return NETTY_MAXORDER_PROPERTY;
    }

    static String getMaxOrderValue() {
        return System.getProperty(NETTY_MAXORDER_PROPERTY);
    }

    static {
        if (System.getProperty(NETTY_MAXORDER_PROPERTY) == null) {
            LOGGER.fine("Setting io.netty.allocator.maxOrder to 6 by default");
            System.setProperty(NETTY_MAXORDER_PROPERTY, HELIDON_MAXORDER_DEFAULT);
        }
    }
}

