/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.webserver.NettyChannel;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.LongAdder;

interface ServerResponseSubscription {
    public void tryRequest();

    public void onSubscribe();

    public void cancel();

    public void inc(NettyChannel var1, int var2);

    public void dec(int var1);

    public static class Unbounded
    implements ServerResponseSubscription {
        private final Flow.Subscription subscription;

        Unbounded(Flow.Subscription subscription) {
            this.subscription = subscription;
        }

        @Override
        public void onSubscribe() {
            this.subscription.request(Long.MAX_VALUE);
        }

        @Override
        public void tryRequest() {
        }

        @Override
        public void cancel() {
            this.subscription.cancel();
        }

        @Override
        public void inc(NettyChannel channel, int byteSize) {
        }

        @Override
        public void dec(int byteSize) {
        }
    }

    public static class WatermarkAutoFlush
    extends WatermarkLinear {
        WatermarkAutoFlush(Flow.Subscription subscription, long watermark) {
            super(subscription, watermark);
        }

        @Override
        public void inc(NettyChannel channel, int byteSize) {
            if (!this.watermarkNotReached()) {
                channel.flush();
            }
            super.inc(channel, byteSize);
        }
    }

    public static class WatermarkPrefetch
    extends WatermarkLinear {
        private int firstChunkSize = 0;
        private long nextRequest = 1L;

        WatermarkPrefetch(Flow.Subscription subscription, long watermark) {
            super(subscription, watermark);
        }

        @Override
        public void onSubscribe() {
            this.tryRequest();
        }

        @Override
        public void tryRequest() {
            if (this.watermarkNotReached()) {
                this.subscription().request(this.nextRequest);
                this.nextRequest = 1L;
            }
        }

        @Override
        public void inc(NettyChannel channel, int byteSize) {
            if (this.firstChunkSize == 0) {
                this.firstChunkSize = byteSize;
                this.nextRequest = this.waterMark() / (long)this.firstChunkSize;
            }
            super.inc(channel, byteSize);
        }
    }

    public static class WatermarkLinear
    implements ServerResponseSubscription {
        private final long waterMark;
        private final LongAdder actualBuffer = new LongAdder();
        private final Flow.Subscription subscription;

        WatermarkLinear(Flow.Subscription subscription, long waterMark) {
            this.subscription = subscription;
            this.waterMark = waterMark;
        }

        @Override
        public void onSubscribe() {
            this.tryRequest();
        }

        @Override
        public void tryRequest() {
            if (this.watermarkNotReached()) {
                this.subscription().request(1L);
            }
        }

        @Override
        public void cancel() {
            this.subscription().cancel();
        }

        @Override
        public void inc(NettyChannel channel, int byteSize) {
            this.actualBuffer.add(byteSize);
        }

        @Override
        public void dec(int byteSize) {
            this.actualBuffer.add(-byteSize);
        }

        protected boolean watermarkNotReached() {
            return this.actualBuffer.sum() <= this.waterMark();
        }

        protected Flow.Subscription subscription() {
            return this.subscription;
        }

        protected long waterMark() {
            return this.waterMark;
        }
    }
}

