/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.context.Context;
import io.helidon.common.http.Http;
import io.helidon.common.http.HttpRequest;
import io.helidon.common.http.UriInfo;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.MessageBodyReadableContent;
import io.helidon.webserver.HttpException;
import io.helidon.webserver.RequestHeaders;
import io.helidon.webserver.WebServer;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;

public interface ServerRequest
extends HttpRequest {
    public void next();

    public void next(Throwable var1);

    public WebServer webServer();

    public Context context();

    public String localAddress();

    public int localPort();

    public String remoteAddress();

    public int remotePort();

    public boolean isSecure();

    public RequestHeaders headers();

    public MessageBodyReadableContent content();

    public long requestId();

    public Optional<SpanContext> spanContext();

    public Tracer tracer();

    public Single<Void> closeConnection();

    public UriInfo requestedUri();

    default public URI absoluteUri() {
        try {
            URI partialUri = new URL(this.isSecure() ? "https" : "http", this.localAddress(), this.localPort(), this.path().absolute().toRawString()).toURI();
            StringBuilder sb = new StringBuilder(partialUri.toString());
            if (this.uri().toString().endsWith("/") && sb.charAt(sb.length() - 1) != '/') {
                sb.append('/');
            }
            if (this.query() != null && !this.query().isEmpty()) {
                sb.append("?").append(this.query());
            }
            if (this.fragment() != null && !this.fragment().isEmpty()) {
                sb.append("#").append(this.fragment());
            }
            return new URI(sb.toString());
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new HttpException("Unable to parse request URL", (Http.ResponseStatus)Http.Status.BAD_REQUEST_400, e);
        }
    }
}

