/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.webserver.DirectHandlers;
import io.helidon.webserver.ExperimentalConfiguration;
import io.helidon.webserver.ForwardingHandler;
import io.helidon.webserver.HelidonConnectionHandler;
import io.helidon.webserver.Http2Configuration;
import io.helidon.webserver.NettyWebServer;
import io.helidon.webserver.ReferenceHoldingQueue;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerConfiguration;
import io.helidon.webserver.SocketConfiguration;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.CleartextHttp2ServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.AsciiString;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;

class HttpInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger LOGGER = Logger.getLogger(HttpInitializer.class.getName());
    static final AttributeKey<String> CLIENT_CERTIFICATE_NAME = AttributeKey.valueOf((String)"client_certificate_name");
    static final AttributeKey<X509Certificate> CLIENT_CERTIFICATE = AttributeKey.valueOf((String)"client_certificate");
    static final AttributeKey<Certificate[]> CLIENT_CERTIFICATE_CHAIN = AttributeKey.valueOf((String)"client_certificate_chain");
    private final NettyWebServer webServer;
    private final DirectHandlers directHandlers;
    private final SocketConfiguration soConfig;
    private final Routing routing;
    private final AtomicBoolean clearLock = new AtomicBoolean();
    private volatile SslContext sslContext;
    private final ReferenceQueue<Object> queues = new ReferenceQueue();
    private final Queue<ReferenceHoldingQueue<?>> unreleasedQueues = new ConcurrentLinkedQueue();

    HttpInitializer(SocketConfiguration soConfig, SslContext sslContext, Routing routing, NettyWebServer webServer, DirectHandlers directHandlers) {
        this.soConfig = soConfig;
        this.routing = routing;
        this.sslContext = sslContext;
        this.webServer = webServer;
        this.directHandlers = directHandlers;
    }

    private void clearQueues() {
        if (this.clearLock.get() || !this.clearLock.compareAndSet(false, true)) {
            return;
        }
        try {
            Reference<Object> r = this.queues.poll();
            while (r != null) {
                if (!(r instanceof ReferenceHoldingQueue.IndirectReference)) {
                    LOGGER.finer(() -> this.log("Unexpected reference in queues", null, new Object[0]));
                } else {
                    ReferenceHoldingQueue q = (ReferenceHoldingQueue)((ReferenceHoldingQueue.IndirectReference)r).acquire();
                    if (q != null && !q.release()) {
                        this.unreleasedQueues.add(q);
                    }
                }
                r = this.queues.poll();
            }
            this.unreleasedQueues.removeIf(ReferenceHoldingQueue::release);
        }
        finally {
            this.clearLock.lazySet(false);
        }
    }

    void queuesShutdown() {
        this.clearQueues();
        this.unreleasedQueues.removeIf(queue -> {
            queue.shutdown();
            return true;
        });
    }

    void updateSslContext(SslContext context) {
        if (this.sslContext == null) {
            throw new IllegalStateException("Current TLS context is not set, update not allowed");
        }
        this.sslContext = context;
    }

    boolean hasTls() {
        return this.sslContext != null;
    }

    public void initChannel(SocketChannel ch) {
        LOGGER.finer(() -> this.log("Initializing channel", (Channel)ch, new Object[0]));
        ChannelPipeline p = ch.pipeline();
        SSLEngine sslEngine = null;
        SslContext context = this.sslContext;
        if (context != null) {
            SslHandler sslHandler = context.newHandler(ch.alloc());
            sslEngine = sslHandler.engine();
            p.addLast(new ChannelHandler[]{sslHandler});
            sslHandler.handshakeFuture().addListener(future -> this.obtainClientCN((Future<? super Channel>)future, ch, sslHandler));
        }
        ServerConfiguration serverConfig = this.webServer.configuration();
        HttpRequestDecoder requestDecoder = new HttpRequestDecoder(this.soConfig.maxInitialLineLength(), this.soConfig.maxHeaderSize(), this.soConfig.maxChunkSize(), this.soConfig.validateHeaders(), this.soConfig.initialBufferSize());
        if (serverConfig.isHttp2Enabled()) {
            LOGGER.finer(() -> this.log("Setting up HTTP/2 pipeline", (Channel)ch, new Object[0]));
            ExperimentalConfiguration experimental = serverConfig.experimental();
            Http2Configuration http2Config = experimental.http2();
            HttpServerCodec sourceCodec = new HttpServerCodec();
            HelidonConnectionHandler helidonHandler = new HelidonConnectionHandler.HelidonHttp2ConnectionHandlerBuilder().maxContentLength(http2Config.maxContentLength()).build();
            HttpServerUpgradeHandler upgradeHandler = new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)sourceCodec, protocol -> AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol) ? new Http2ServerUpgradeCodec((Http2ConnectionHandler)helidonHandler) : null, http2Config.maxContentLength());
            CleartextHttp2ServerUpgradeHandler cleartextHttp2ServerUpgradeHandler = new CleartextHttp2ServerUpgradeHandler(sourceCodec, upgradeHandler, (ChannelHandler)helidonHandler);
            p.addLast(new ChannelHandler[]{cleartextHttp2ServerUpgradeHandler});
            p.addLast(new ChannelHandler[]{new HelidonEventLogger()});
        } else {
            p.addLast(new ChannelHandler[]{requestDecoder});
            p.addLast(new ChannelHandler[]{new HttpResponseEncoder()});
        }
        if (serverConfig.enableCompression()) {
            LOGGER.finer(() -> this.log("Compression negotiation enabled (gzip, deflate)", (Channel)ch, new Object[0]));
            p.addLast(new ChannelHandler[]{new HttpContentCompressor()});
        }
        p.addLast(new ChannelHandler[]{new ForwardingHandler(this.routing, this.webServer, sslEngine, this.queues, this::clearQueues, this.soConfig, requestDecoder, this.directHandlers)});
        int idleTimeout = this.soConfig.connectionIdleTimeout();
        if (idleTimeout > 0) {
            p.addLast(new ChannelHandler[]{new IdleStateHandler(idleTimeout, idleTimeout, idleTimeout)});
            p.addLast(new ChannelHandler[]{new ChannelDuplexHandler(){

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                    if (evt instanceof IdleStateEvent) {
                        LOGGER.finer(() -> HttpInitializer.this.log("Closing idle connection on channel", ctx.channel(), new Object[0]));
                        ctx.close();
                    }
                }
            }});
        }
        ch.eventLoop().execute(this::clearQueues);
    }

    private void obtainClientCN(Future<? super Channel> future, SocketChannel ch, SslHandler sslHandler) {
        if (future.cause() == null) {
            try {
                Certificate[] peerCertificates = sslHandler.engine().getSession().getPeerCertificates();
                if (peerCertificates.length >= 1) {
                    int end;
                    Certificate certificate = peerCertificates[0];
                    X509Certificate cert = (X509Certificate)certificate;
                    Principal principal = cert.getSubjectDN();
                    int start = principal.getName().indexOf("CN=");
                    String tmpName = "Unknown CN";
                    if (start >= 0 && (end = (tmpName = principal.getName().substring(start + 3)).indexOf(",")) > 0) {
                        tmpName = tmpName.substring(0, end);
                    }
                    ch.attr(CLIENT_CERTIFICATE_NAME).set((Object)tmpName);
                    ch.attr(CLIENT_CERTIFICATE).set((Object)cert);
                    ch.attr(CLIENT_CERTIFICATE_CHAIN).set((Object)peerCertificates);
                }
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
        }
    }

    private String log(String template, Channel channel, Object ... params) {
        ArrayList<Object> list = new ArrayList<Object>(params.length + 2);
        list.add(System.identityHashCode((Object)this));
        list.add(channel != null ? channel.id() : "N/A");
        list.addAll(Arrays.asList(params));
        return String.format("[Initializer: %s, Channel: 0x%s] " + template, list.toArray());
    }

    private final class HelidonEventLogger
    extends ChannelInboundHandlerAdapter {
        private HelidonEventLogger() {
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            LOGGER.finest(() -> HttpInitializer.this.log("Event: %s", ctx.channel(), evt));
            ctx.fireUserEventTriggered(evt);
        }
    }
}

