/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.http.Http;
import io.helidon.webserver.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

interface Route {
    public static final PathMatcher EMPTY_PATH_MATCHER = new PathMatcher(){

        @Override
        public PathMatcher.Result match(CharSequence path) {
            return this.prefixMatch(path);
        }

        @Override
        public PathMatcher.PrefixResult prefixMatch(final CharSequence path) {
            return new PathMatcher.PrefixResult(){

                @Override
                public String remainingPart() {
                    if (path == null) {
                        return null;
                    }
                    return path.toString();
                }

                @Override
                public boolean matches() {
                    return true;
                }

                @Override
                public Map<String, String> params() {
                    return Collections.emptyMap();
                }

                @Override
                public String param(String name) {
                    return null;
                }
            };
        }
    };

    default public Set<Http.RequestMethod> acceptedMethods() {
        return null;
    }

    default public boolean accepts(Http.RequestMethod method) {
        return false;
    }

    public static class HttpMethodPredicate
    implements Predicate<Http.RequestMethod> {
        private final boolean allMethods;
        private final EnumSet<Http.Method> standardMethods;
        private final Set<Http.RequestMethod> otherMethods;

        HttpMethodPredicate(Collection<Http.RequestMethod> methods) {
            if (methods == null || methods.isEmpty()) {
                this.allMethods = true;
                this.standardMethods = null;
                this.otherMethods = null;
            } else {
                this.allMethods = false;
                this.otherMethods = new HashSet<Http.RequestMethod>();
                ArrayList<Http.Method> sms = new ArrayList<Http.Method>(methods.size());
                for (Http.RequestMethod method : methods) {
                    if (method instanceof Http.Method) {
                        sms.add((Http.Method)method);
                        continue;
                    }
                    this.otherMethods.add(method);
                }
                this.standardMethods = sms.isEmpty() ? EnumSet.noneOf(Http.Method.class) : EnumSet.copyOf(sms);
            }
        }

        @Override
        public boolean test(Http.RequestMethod method) {
            if (this.allMethods) {
                return true;
            }
            if (method instanceof Http.Method) {
                return this.standardMethods.contains(method);
            }
            return this.otherMethods.contains(method);
        }

        public Set<Http.RequestMethod> acceptedMethods() {
            if (this.allMethods) {
                return Collections.emptySet();
            }
            HashSet<Http.RequestMethod> result = new HashSet<Http.RequestMethod>(this.standardMethods.size() + this.otherMethods.size());
            result.addAll(this.standardMethods);
            result.addAll(this.otherMethods);
            return result;
        }
    }
}

