/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.webserver.Router;
import io.helidon.webserver.spi.UpgradeCodecProvider;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;

class UpgradeManager {
    private static final Map<CharSequence, UpgradeCodecProvider> UPGRADE_HANDLERS = new HashMap<CharSequence, UpgradeCodecProvider>();
    private static final ApplicationProtocolConfig APPLICATION_PROTOCOL_CONFIG;
    private static final boolean NO_UPGRADES;

    private UpgradeManager() {
    }

    static ApplicationProtocolConfig alpnConfig() {
        return APPLICATION_PROTOCOL_CONFIG;
    }

    static Optional<ChannelHandler> priorKnowledgeWrapper(HttpServerCodec httpServerCodec, HttpServerUpgradeHandler wrappedUpgradeHandler, int maxContentLength) {
        return UPGRADE_HANDLERS.values().stream().map(uhs -> uhs.priorKnowledgeDecoder(httpServerCodec, wrappedUpgradeHandler, maxContentLength)).filter(Optional::isPresent).findFirst().flatMap(Function.identity());
    }

    static void addUpgradeHandler(ChannelPipeline p, Router router, HttpServerCodec sourceCodec, int maxContentLength) {
        if (NO_UPGRADES) {
            p.addLast(new ChannelHandler[]{sourceCodec});
            return;
        }
        HttpServerUpgradeHandler upgradeHandler = new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)sourceCodec, protocol -> {
            UpgradeCodecProvider upgradeCodecProvider = UPGRADE_HANDLERS.get(protocol);
            if (upgradeCodecProvider == null) {
                return null;
            }
            return upgradeCodecProvider.upgradeCodec(sourceCodec, router, maxContentLength);
        }, maxContentLength);
        Optional<ChannelHandler> priorKnowledgeWrapper = UpgradeManager.priorKnowledgeWrapper(sourceCodec, upgradeHandler, maxContentLength);
        if (priorKnowledgeWrapper.isEmpty()) {
            p.addLast(new ChannelHandler[]{sourceCodec});
            p.addLast(new ChannelHandler[]{upgradeHandler});
        } else {
            p.addLast(new ChannelHandler[]{priorKnowledgeWrapper.get()});
        }
    }

    static {
        ArrayList<String> alpnProtocols = new ArrayList<String>();
        HelidonServiceLoader.create(ServiceLoader.load(UpgradeCodecProvider.class)).forEach(upgradeHandlerSupplier -> {
            UPGRADE_HANDLERS.put(upgradeHandlerSupplier.clearTextProtocol(), (UpgradeCodecProvider)upgradeHandlerSupplier);
            upgradeHandlerSupplier.tlsProtocol().ifPresent(alpnProtocols::add);
        });
        NO_UPGRADES = UPGRADE_HANDLERS.isEmpty();
        alpnProtocols.add("http/1.1");
        APPLICATION_PROTOCOL_CONFIG = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, alpnProtocols);
    }
}

