/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.common.http.Http;
import io.helidon.config.Config;
import io.helidon.tracing.HeaderProvider;
import io.helidon.tracing.Span;
import io.helidon.tracing.SpanContext;
import io.helidon.tracing.Tag;
import io.helidon.tracing.Tracer;
import io.helidon.tracing.config.SpanTracingConfig;
import io.helidon.tracing.config.TracingConfig;
import io.helidon.tracing.config.TracingConfigUtil;
import io.helidon.webserver.Handler;
import io.helidon.webserver.PathTracingConfig;
import io.helidon.webserver.ServerConfiguration;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.Service;
import io.helidon.webserver.WebServer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public abstract class WebTracingConfig {
    abstract TracingConfig envConfig();

    abstract Iterable<PathTracingConfig> pathConfigs();

    public static WebTracingConfig create() {
        return WebTracingConfig.create(TracingConfig.ENABLED);
    }

    public static WebTracingConfig create(TracingConfig configuration) {
        return WebTracingConfig.builder().envConfig(configuration).build();
    }

    public static WebTracingConfig create(Config config) {
        return WebTracingConfig.builder().config(config).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static Tracer tracer(WebServer webServer) {
        Tracer tracer;
        ServerConfiguration configuration;
        if (null != webServer && null != (configuration = webServer.configuration()) && null != (tracer = configuration.tracer())) {
            return tracer;
        }
        return Contexts.context().flatMap(ctx -> ctx.get(Tracer.class)).orElseGet(Tracer::global);
    }

    Service service() {
        return rules -> {
            this.pathConfigs().forEach(path -> {
                List<Http.RequestMethod> methods = path.methods().stream().map(Http.RequestMethod::create).collect(Collectors.toList());
                TracingConfig wrappedPath = path.tracedConfig();
                if (methods.isEmpty()) {
                    rules.any(path.path(), new TracingConfigHandler(wrappedPath));
                } else {
                    rules.anyOf(methods, path.path(), new TracingConfigHandler(wrappedPath));
                }
            });
            rules.any(new RequestSpanHandler());
        };
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, WebTracingConfig> {
        private final List<PathTracingConfig> pathTracingConfigs = new LinkedList<PathTracingConfig>();
        private TracingConfig tracedConfig = TracingConfig.ENABLED;

        Builder() {
            this.addPathConfig(PathTracingConfig.builder().path("/metrics").tracingConfig(TracingConfig.DISABLED).build());
            this.addPathConfig(PathTracingConfig.builder().path("/metrics/{+}").tracingConfig(TracingConfig.DISABLED).build());
            this.addPathConfig(PathTracingConfig.builder().path("/health").tracingConfig(TracingConfig.DISABLED).build());
            this.addPathConfig(PathTracingConfig.builder().path("/health/{+}").tracingConfig(TracingConfig.DISABLED).build());
            this.addPathConfig(PathTracingConfig.builder().path("/openapi").tracingConfig(TracingConfig.DISABLED).build());
        }

        public WebTracingConfig build() {
            final TracingConfig envConfig = this.tracedConfig;
            final LinkedList<PathTracingConfig> pathConfigs = new LinkedList<PathTracingConfig>(this.pathTracingConfigs);
            return new WebTracingConfig(){

                @Override
                public TracingConfig envConfig() {
                    return envConfig;
                }

                @Override
                public Iterable<PathTracingConfig> pathConfigs() {
                    return pathConfigs;
                }
            };
        }

        public Builder addPathConfig(PathTracingConfig pathTracingConfig) {
            this.pathTracingConfigs.add(pathTracingConfig);
            return this;
        }

        public Builder envConfig(TracingConfig tracingConfig) {
            this.tracedConfig = tracingConfig;
            return this;
        }

        public Builder config(Config config) {
            this.envConfig(TracingConfig.create((Config)config));
            Config allPaths = config.get("paths");
            allPaths.asNodeList().ifPresent(this::addPaths);
            return this;
        }

        private void addPaths(List<Config> configs) {
            configs.stream().map(PathTracingConfig::create).forEach(this::addPathConfig);
        }
    }

    static final class RequestSpanHandler
    implements Handler {
        private static final String TRACING_SPAN_HTTP_REQUEST = "HTTP Request";
        private final AtomicBoolean checkedIfShouldTrace = new AtomicBoolean();
        private volatile boolean shouldTrace = true;

        RequestSpanHandler() {
        }

        @Override
        public void accept(ServerRequest req, ServerResponse res) {
            if (this.shouldTrace && this.checkedIfShouldTrace.compareAndSet(false, true)) {
                this.shouldTrace = req.tracer().enabled();
            }
            if (this.shouldTrace) {
                this.doAccept(req, res);
            }
            req.next();
        }

        private void doAccept(ServerRequest req, ServerResponse res) {
            Tracer tracer = req.tracer();
            Context context = req.context();
            SpanTracingConfig spanConfig = TracingConfigUtil.spanConfig((String)"web-server", (String)TRACING_SPAN_HTTP_REQUEST, (Context)context);
            SpanContext inboundSpanContext = tracer.extract((HeaderProvider)new TracingHeaderProvider(req.headers().toMap())).orElse(null);
            if (inboundSpanContext != null) {
                context.register((Object)inboundSpanContext);
                context.register(ServerRequest.class, (Object)inboundSpanContext);
            }
            if (!spanConfig.enabled()) {
                return;
            }
            String spanName = spanConfig.newName().orElse(TRACING_SPAN_HTTP_REQUEST);
            if (spanName.indexOf(37) > -1) {
                spanName = String.format(spanName, req.method().name(), req.path(), req.query());
            }
            Span.Builder spanBuilder = tracer.spanBuilder(spanName).kind(Span.Kind.SERVER).tag(Tag.COMPONENT.create((Object)"helidon-webserver")).tag(Tag.HTTP_METHOD.create((Object)req.method().name())).tag(Tag.HTTP_URL.create((Object)req.uri().toString())).tag(Tag.HTTP_VERSION.create((Object)req.version().value()));
            if (inboundSpanContext != null) {
                spanBuilder.parent(inboundSpanContext);
            }
            Span span = spanBuilder.start();
            context.register((Object)span.context());
            context.register(ServerRequest.class, (Object)span.context());
            res.whenSent().thenRun(() -> {
                Http.ResponseStatus httpStatus = res.status();
                if (httpStatus != null) {
                    int statusCode = httpStatus.code();
                    span.tag(Tag.HTTP_STATUS.create((Object)statusCode));
                    if (statusCode >= 400) {
                        span.status(Span.Status.ERROR);
                        span.addEvent("error", Map.of("message", "Response HTTP status: " + statusCode, "error.kind", statusCode < 500 ? "ClientError" : "ServerError"));
                    }
                }
                span.end();
            }).exceptionally(t -> {
                span.end(t);
                return null;
            });
        }

        private static class TracingHeaderProvider
        implements HeaderProvider {
            private final Map<String, List<String>> headers;

            TracingHeaderProvider(Map<String, List<String>> headers) {
                this.headers = headers;
            }

            public Iterable<String> keys() {
                return this.headers.keySet();
            }

            public Optional<String> get(String key) {
                List<String> strings = this.headers.get(key);
                if (strings == null) {
                    return Optional.empty();
                }
                return Optional.of(strings.get(0));
            }

            public Iterable<String> getAll(String key) {
                List<String> strings = this.headers.get(key);
                if (strings == null) {
                    return List.of();
                }
                return strings;
            }

            public boolean contains(String key) {
                return this.headers.containsKey(key);
            }
        }
    }

    private static final class TracingConfigHandler
    implements Handler {
        private final TracingConfig pathSpecific;

        private TracingConfigHandler(TracingConfig pathSpecific) {
            this.pathSpecific = pathSpecific;
        }

        @Override
        public void accept(ServerRequest req, ServerResponse res) {
            Optional existing = req.context().get(TracingConfig.class);
            if (existing.isPresent()) {
                req.context().register((Object)TracingConfig.merge((TracingConfig)((TracingConfig)existing.get()), (TracingConfig)this.pathSpecific));
            } else {
                req.context().register((Object)this.pathSpecific);
            }
            req.next();
        }
    }
}

