/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.handler.codec.http.HttpExpectationFailedEvent;
import io.netty.util.concurrent.Future;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

class NettyChannel {
    private final Channel channel;
    private final ChannelHandlerContext ctx;
    private CompletionStage<ChannelFuture> writeFuture = CompletableFuture.completedFuture(null);

    NettyChannel(ChannelHandlerContext ctx) {
        this.ctx = ctx;
        this.channel = ctx.channel();
    }

    ChannelId id() {
        return this.channel.id();
    }

    void read() {
        this.channel.read();
    }

    void flush() {
        this.writeFuture = this.writeFuture.thenApply(f -> {
            if (this.channel.eventLoop().inEventLoop()) {
                this.channel.flush();
            } else {
                this.channel.eventLoop().execute(() -> ((Channel)this.channel).flush());
            }
            return f;
        });
    }

    void write(boolean flush, Object msg, Function<ChannelFuture, ChannelFuture> listeners) {
        this.writeFuture = this.writeFuture.thenCompose(f -> this.writeInt(flush, msg, listeners));
    }

    private CompletionStage<ChannelFuture> writeInt(boolean flush, Object msg, Function<ChannelFuture, ChannelFuture> listeners) {
        CompletableFuture<ChannelFuture> channelFuture = new CompletableFuture<ChannelFuture>();
        if (this.channel.eventLoop().inEventLoop()) {
            if (flush) {
                channelFuture.complete(listeners.apply(this.channel.writeAndFlush(msg)));
            } else {
                channelFuture.complete(listeners.apply(this.channel.write(msg)));
            }
        } else if (flush) {
            this.channel.eventLoop().execute(() -> channelFuture.complete((ChannelFuture)listeners.apply(this.channel.writeAndFlush(msg))));
        } else {
            this.channel.eventLoop().execute(() -> channelFuture.complete((ChannelFuture)listeners.apply(this.channel.write(msg))));
        }
        return channelFuture;
    }

    static <T> void completeFuture(Future<? super Void> nettyFuture, CompletableFuture<T> completable, T item) {
        if (nettyFuture.isSuccess()) {
            completable.complete(item);
        } else {
            completable.completeExceptionally(nettyFuture.cause());
        }
    }

    void expectationFailed() {
        this.ctx.pipeline().fireUserEventTriggered((Object)HttpExpectationFailedEvent.INSTANCE);
    }

    public String toString() {
        return "NettyChannel{channel=" + this.channel.toString() + "}";
    }
}

