/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Http;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.Single;
import io.helidon.webserver.BareRequest;
import io.helidon.webserver.NettyWebServer;
import io.helidon.webserver.SocketConfiguration;
import io.helidon.webserver.WebServer;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import javax.net.ssl.SSLEngine;

class BareRequestImpl
implements BareRequest {
    private final SocketConfiguration soConfig;
    private final HttpRequest nettyRequest;
    private final Flow.Publisher<DataChunk> publisher;
    private final WebServer webServer;
    private final ChannelHandlerContext ctx;
    private final SSLEngine sslEngine;
    private final long requestId;
    private final URI uri;

    BareRequestImpl(NettyWebServer webServer, SocketConfiguration soConfig, SSLEngine sslEngine, ChannelHandlerContext ctx, HttpRequest request, Multi<DataChunk> publisher, long requestId) {
        this.webServer = webServer;
        this.soConfig = soConfig;
        this.sslEngine = sslEngine;
        this.ctx = ctx;
        this.nettyRequest = request;
        this.publisher = publisher;
        this.requestId = requestId;
        this.uri = URI.create(this.nettyRequest.uri());
    }

    @Override
    public WebServer webServer() {
        return this.webServer;
    }

    @Override
    public Http.RequestMethod method() {
        return Http.RequestMethod.create((String)this.nettyRequest.method().name());
    }

    @Override
    public Http.Version version() {
        if (this.nettyRequest.protocolVersion() == HttpVersion.HTTP_1_1) {
            return Http.Version.V1_1;
        }
        return Http.Version.create((String)this.nettyRequest.protocolVersion().text());
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    @Override
    public String localAddress() {
        return this.hostString(this.ctx.channel().localAddress());
    }

    @Override
    public int localPort() {
        return this.port(this.ctx.channel().localAddress());
    }

    @Override
    public String remoteAddress() {
        return this.hostString(this.ctx.channel().remoteAddress());
    }

    @Override
    public int remotePort() {
        return this.port(this.ctx.channel().remoteAddress());
    }

    @Override
    public SocketConfiguration socketConfiguration() {
        return this.soConfig;
    }

    private String hostString(SocketAddress address) {
        return address instanceof InetSocketAddress ? ((InetSocketAddress)address).getHostString() : null;
    }

    private int port(SocketAddress address) {
        return address instanceof InetSocketAddress ? ((InetSocketAddress)address).getPort() : -1;
    }

    @Override
    public boolean isSecure() {
        return this.sslEngine != null;
    }

    @Override
    public Map<String, List<String>> headers() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (Map.Entry entry : this.nettyRequest.headers().entries()) {
            map.computeIfAbsent((String)entry.getKey(), s -> new ArrayList()).add((String)entry.getValue());
        }
        return map;
    }

    @Override
    public Flow.Publisher<DataChunk> bodyPublisher() {
        return this.publisher;
    }

    @Override
    public long requestId() {
        return this.requestId;
    }

    @Override
    public Single<Void> closeConnection() {
        CompletableFuture cf = new CompletableFuture();
        this.ctx.close().addListener(f -> {
            if (f.isSuccess()) {
                cf.complete(null);
            } else if (f.isCancelled()) {
                cf.cancel(true);
            } else {
                cf.completeExceptionally(f.cause());
            }
        });
        return Single.create(cf, (boolean)true);
    }
}

