/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.http.Http;
import io.helidon.webserver.DirectHandler;
import java.util.EnumMap;
import java.util.Map;

class DirectHandlers {
    private final Map<DirectHandler.EventType, DirectHandler> handlers;

    private DirectHandlers(Map<DirectHandler.EventType, DirectHandler> handlers) {
        this.handlers = new EnumMap<DirectHandler.EventType, DirectHandler>(handlers);
    }

    static Builder builder() {
        return new Builder();
    }

    DirectHandler handler(DirectHandler.EventType eventType) {
        return this.handlers.get((Object)eventType);
    }

    static class Builder
    implements io.helidon.common.Builder<Builder, DirectHandlers> {
        private final Map<DirectHandler.EventType, DirectHandler> handlers = new EnumMap<DirectHandler.EventType, DirectHandler>(DirectHandler.EventType.class);
        private final DirectHandler defaultHandler = new DefaultHandler();

        private Builder() {
        }

        public DirectHandlers build() {
            for (DirectHandler.EventType value : DirectHandler.EventType.values()) {
                this.handlers.putIfAbsent(value, this.defaultHandler);
            }
            return new DirectHandlers(this.handlers);
        }

        Builder addHandler(DirectHandler.EventType eventType, DirectHandler handler) {
            this.handlers.put(eventType, handler);
            return this;
        }
    }

    private static class DefaultHandler
    implements DirectHandler {
        private DefaultHandler() {
        }

        @Override
        public DirectHandler.TransportResponse handle(DirectHandler.TransportRequest request, DirectHandler.EventType eventType, Http.ResponseStatus defaultStatus, String message) {
            DirectHandler.TransportResponse.Builder builder = DirectHandler.TransportResponse.builder().status(defaultStatus);
            if (!message.isEmpty()) {
                builder.entity(message);
            }
            return builder.build();
        }
    }
}

