/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.webserver.DirectHandlers;
import io.helidon.webserver.ForwardingHandler;
import io.helidon.webserver.NettyWebServer;
import io.helidon.webserver.ReferenceHoldingQueue;
import io.helidon.webserver.RequestRouting;
import io.helidon.webserver.Router;
import io.helidon.webserver.ServerConfiguration;
import io.helidon.webserver.SocketConfiguration;
import io.helidon.webserver.UpgradeManager;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.auth.x500.X500Principal;

class HttpInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger LOGGER = Logger.getLogger(HttpInitializer.class.getName());
    static final AttributeKey<String> CLIENT_CERTIFICATE_NAME = AttributeKey.valueOf((String)"client_certificate_name");
    static final AttributeKey<X509Certificate> CLIENT_CERTIFICATE = AttributeKey.valueOf((String)"client_certificate");
    static final AttributeKey<Certificate[]> CLIENT_CERTIFICATE_CHAIN = AttributeKey.valueOf((String)"client_certificate_chain");
    private final NettyWebServer webServer;
    private final DirectHandlers directHandlers;
    private final SocketConfiguration soConfig;
    private final Router router;
    private final AtomicBoolean clearLock = new AtomicBoolean();
    private volatile SslContext sslContext;
    private final ReferenceQueue<Object> queues = new ReferenceQueue();
    private final Queue<ReferenceHoldingQueue<?>> unreleasedQueues = new ConcurrentLinkedQueue();

    HttpInitializer(SocketConfiguration soConfig, SslContext sslContext, Router router, NettyWebServer webServer, DirectHandlers directHandlers) {
        this.soConfig = soConfig;
        this.router = router;
        this.sslContext = sslContext;
        this.webServer = webServer;
        this.directHandlers = directHandlers;
    }

    private void clearQueues() {
        if (this.clearLock.get() || !this.clearLock.compareAndSet(false, true)) {
            return;
        }
        try {
            Reference<Object> r = this.queues.poll();
            while (r != null) {
                if (!(r instanceof ReferenceHoldingQueue.IndirectReference)) {
                    this.log("Unexpected reference in queues", null);
                } else {
                    ReferenceHoldingQueue q = (ReferenceHoldingQueue)((ReferenceHoldingQueue.IndirectReference)r).acquire();
                    if (q != null && !q.release()) {
                        this.unreleasedQueues.add(q);
                    }
                }
                r = this.queues.poll();
            }
            this.unreleasedQueues.removeIf(ReferenceHoldingQueue::release);
        }
        finally {
            this.clearLock.lazySet(false);
        }
    }

    void queuesShutdown() {
        this.clearQueues();
        this.unreleasedQueues.removeIf(queue -> {
            queue.shutdown();
            return true;
        });
    }

    void updateSslContext(SslContext context) {
        if (this.sslContext == null) {
            throw new IllegalStateException("Current TLS context is not set, update not allowed");
        }
        this.sslContext = context;
    }

    boolean hasTls() {
        return this.sslContext != null;
    }

    public void initChannel(SocketChannel ch) {
        RequestRouting requestRouting;
        this.log("Initializing channel", (Channel)ch);
        ChannelPipeline p = ch.pipeline();
        SSLEngine sslEngine = null;
        SslContext context = this.sslContext;
        if (context != null) {
            SslHandler sslHandler = context.newHandler(ch.alloc());
            sslEngine = sslHandler.engine();
            p.addLast(new ChannelHandler[]{sslHandler});
            sslHandler.handshakeFuture().addListener(future -> this.obtainClientCN((Future<? super Channel>)future, ch, sslHandler));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            p.addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.DEBUG)});
        }
        ServerConfiguration serverConfig = this.webServer.configuration();
        HttpServerCodec sourceCodec = new HttpServerCodec(this.soConfig.maxInitialLineLength(), this.soConfig.maxHeaderSize(), this.soConfig.maxChunkSize(), this.soConfig.validateHeaders(), this.soConfig.initialBufferSize());
        UpgradeManager.addUpgradeHandler(p, this.router, sourceCodec, this.soConfig.maxUpgradeContentLength());
        if (serverConfig.enableCompression()) {
            this.log("Compression negotiation enabled (gzip, deflate)", (Channel)ch);
            p.addLast(new ChannelHandler[]{new HttpContentCompressor()});
        }
        if ((requestRouting = (RequestRouting)this.router.routing(RequestRouting.class, null)) != null) {
            p.addLast(new ChannelHandler[]{new ForwardingHandler(requestRouting, this.webServer, sslEngine, this.queues, this::clearQueues, this.soConfig, this.directHandlers)});
        }
        ch.eventLoop().execute(this::clearQueues);
    }

    private void obtainClientCN(Future<? super Channel> future, SocketChannel ch, SslHandler sslHandler) {
        if (future.cause() == null) {
            try {
                Certificate[] peerCertificates = sslHandler.engine().getSession().getPeerCertificates();
                if (peerCertificates.length >= 1) {
                    int end;
                    Certificate certificate = peerCertificates[0];
                    X509Certificate cert = (X509Certificate)certificate;
                    X500Principal principal = cert.getSubjectX500Principal();
                    int start = principal.getName().indexOf("CN=");
                    String tmpName = "Unknown CN";
                    if (start >= 0 && (end = (tmpName = principal.getName().substring(start + 3)).indexOf(",")) > 0) {
                        tmpName = tmpName.substring(0, end);
                    }
                    ch.attr(CLIENT_CERTIFICATE_NAME).set((Object)tmpName);
                    ch.attr(CLIENT_CERTIFICATE).set((Object)cert);
                    ch.attr(CLIENT_CERTIFICATE_CHAIN).set((Object)peerCertificates);
                }
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
        }
    }

    private void log(String msg, Channel channel) {
        if (LOGGER.isLoggable(Level.FINER)) {
            String channelId = channel != null ? channel.id().toString() : "N/A";
            LOGGER.finer("[Initializer: " + System.identityHashCode((Object)this) + ", Channel: 0x" + channelId + "] " + msg);
        }
    }
}

