/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.webserver.Router;
import io.helidon.webserver.Routing;
import java.util.IdentityHashMap;
import java.util.Map;

class RouterImpl
implements Router {
    private static final RouterImpl EMPTY = RouterImpl.builder().build();
    private final Map<Class<?>, Routing> routings;
    private final Map<Class<? extends Routing>, Routing.Builder> routingBuilders;

    private RouterImpl(Builder builder) {
        this.routings = new IdentityHashMap(builder.routings);
        this.routingBuilders = new IdentityHashMap<Class<? extends Routing>, Routing.Builder>(builder.routingBuilders);
    }

    static Builder builder() {
        return new Builder();
    }

    static RouterImpl empty() {
        return EMPTY;
    }

    @Override
    public <T extends Routing> T routing(Class<T> routingType, T defaultValue) {
        Routing.Builder builder;
        Routing routing = (Routing)routingType.cast(this.routings.get(routingType));
        if (routing == null && (builder = this.routingBuilders.get(routingType)) != null) {
            return (T)((Routing)routingType.cast(builder.build()));
        }
        return (T)(routing == null ? defaultValue : routing);
    }

    @Override
    public void afterStop() {
        for (Routing value : this.routings.values()) {
            value.afterStop();
        }
    }

    @Override
    public void beforeStart() {
        for (Routing value : this.routings.values()) {
            value.beforeStart();
        }
    }

    <T extends Routing> Object routingBuilder(Class<T> routingType) {
        return routingType.cast(this.routingBuilders.get(routingType).build());
    }

    static class Builder
    implements Router.Builder {
        private static final System.Logger LOGGER = System.getLogger(Builder.class.getName());
        private final Map<Class<?>, Routing> routings = new IdentityHashMap();
        private final Map<Class<? extends Routing>, Routing.Builder> routingBuilders = new IdentityHashMap<Class<? extends Routing>, Routing.Builder>();

        private Builder() {
        }

        public RouterImpl build() {
            return new RouterImpl(this);
        }

        @Override
        public Builder addRouting(Routing routing) {
            Routing previous = this.routings.put(routing.getClass(), routing);
            if (previous != null) {
                LOGGER.log(System.Logger.Level.WARNING, "Second routing of the same type is registered. The first instance will be ignored. Type: " + routing.getClass().getName());
            }
            return this;
        }

        Builder addRoutingBuilder(Class<? extends Routing> routingType, Routing.Builder routingBuilder) {
            this.routingBuilders.put(routingType, routingBuilder);
            return this;
        }
    }
}

