/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.config.metadata.ConfiguredOption;
import java.net.SocketOption;
import java.time.Duration;
import java.util.Map;

@Prototype.Blueprint
interface ConnectionConfigBlueprint {
    public static final String DEFAULT_READ_TIMEOUT_DURATION = "PT30S";
    public static final String DEFAULT_CONNECT_TIMEOUT_DURATION = "PT10S";
    public static final String DEFAULT_SO_BUFFER_SIZE = "32768";

    @ConfiguredOption(value="PT30S")
    public Duration readTimeout();

    @ConfiguredOption(value="PT10S")
    public Duration connectTimeout();

    @ConfiguredOption(value="32768")
    public int sendBufferSize();

    @ConfiguredOption(value="32768")
    public int receiveBufferSize();

    @ConfiguredOption(value="true")
    public boolean keepAlive();

    @ConfiguredOption(value="true")
    public boolean reuseAddress();

    @ConfiguredOption(value="false")
    public boolean tcpNoDelay();

    @Option.Singular
    public Map<SocketOption<?>, Object> socketOptions();
}

