/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.DataReader;
import io.helidon.common.buffers.DataWriter;
import io.helidon.common.socket.HelidonSocket;
import io.helidon.common.socket.PeerInfo;
import io.helidon.common.socket.SocketWriter;
import io.helidon.common.task.InterruptableTask;
import io.helidon.http.HttpException;
import io.helidon.http.RequestException;
import io.helidon.webserver.CloseConnectionException;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.ConnectionProviders;
import io.helidon.webserver.ListenerContext;
import io.helidon.webserver.Router;
import io.helidon.webserver.spi.ServerConnection;
import io.helidon.webserver.spi.ServerConnectionSelector;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.function.Supplier;

class ConnectionHandler
implements InterruptableTask<Void>,
ConnectionContext {
    private static final System.Logger LOGGER = System.getLogger(ConnectionHandler.class.getName());
    private final ListenerContext listenerContext;
    private final Semaphore connectionSemaphore;
    private final Semaphore requestSemaphore;
    private final ConnectionProviders connectionProviders;
    private final List<ServerConnectionSelector> providerCandidates;
    private final Map<String, ServerConnection> activeConnections;
    private final HelidonSocket socket;
    private final Router router;
    private final SocketWriter writer;
    private final DataReader reader;
    private ServerConnection connection;

    ConnectionHandler(ListenerContext listenerContext, Semaphore connectionSemaphore, Semaphore requestSemaphore, ConnectionProviders connectionProviders, Map<String, ServerConnection> activeConnections, HelidonSocket socket, Router router) {
        this.listenerContext = listenerContext;
        this.connectionSemaphore = connectionSemaphore;
        this.requestSemaphore = requestSemaphore;
        this.connectionProviders = connectionProviders;
        this.providerCandidates = connectionProviders.providerCandidates();
        this.activeConnections = activeConnections;
        this.socket = socket;
        this.router = router;
        this.writer = SocketWriter.create((ExecutorService)listenerContext.executor(), (HelidonSocket)socket, (int)listenerContext.config().writeQueueLength());
        this.reader = new DataReader((Supplier)socket);
    }

    public boolean canInterrupt() {
        InterruptableTask task;
        ServerConnection serverConnection = this.connection;
        return serverConnection instanceof InterruptableTask && (task = (InterruptableTask)serverConnection).canInterrupt();
    }

    public final void run() {
        String socketsId = this.socket.socketId() + " " + this.socket.childSocketId();
        Thread.currentThread().setName("[" + socketsId + "] WebServer socket");
        if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
            this.socket.log(LOGGER, System.Logger.Level.DEBUG, "accepted socket from %s:%d", new Object[]{this.socket.remotePeer().host(), this.socket.remotePeer().port()});
        }
        try {
            if (this.socket.protocolNegotiated()) {
                this.connection = this.connectionProviders.byApplicationProtocol(this.socket.protocol()).connection(this);
            }
            if (this.connection == null) {
                this.connection = this.identifyConnection();
            }
            if (this.connection == null) {
                throw new CloseConnectionException("No suitable connection provider");
            }
            this.activeConnections.put(socketsId, this.connection);
            this.connection.handle(this.requestSemaphore);
        }
        catch (RequestException e) {
            this.socket.log(LOGGER, System.Logger.Level.WARNING, "escaped Request exception", (Throwable)e, new Object[0]);
        }
        catch (HttpException e) {
            this.socket.log(LOGGER, System.Logger.Level.WARNING, "escaped HTTP exception", (Throwable)e, new Object[0]);
        }
        catch (CloseConnectionException e) {
            this.socket.log(LOGGER, System.Logger.Level.TRACE, "connection close requested", (Throwable)e, new Object[0]);
        }
        catch (UncheckedIOException e) {
            this.socket.log(LOGGER, System.Logger.Level.TRACE, "received I/O exception", (Throwable)e, new Object[0]);
        }
        catch (Exception e) {
            this.socket.log(LOGGER, System.Logger.Level.WARNING, "unexpected exception", (Throwable)e, new Object[0]);
        }
        finally {
            this.connectionSemaphore.release();
            this.activeConnections.remove(socketsId);
            this.writer.close();
            this.closeChannel();
        }
        this.socket.log(LOGGER, System.Logger.Level.DEBUG, "socket closed", new Object[0]);
    }

    public PeerInfo remotePeer() {
        return this.socket.remotePeer();
    }

    public PeerInfo localPeer() {
        return this.socket.localPeer();
    }

    public boolean isSecure() {
        return this.socket.isSecure();
    }

    public String socketId() {
        return this.socket.socketId();
    }

    public String childSocketId() {
        return this.socket.childSocketId();
    }

    @Override
    public ListenerContext listenerContext() {
        return this.listenerContext;
    }

    @Override
    public ExecutorService executor() {
        return this.listenerContext.executor();
    }

    @Override
    public DataWriter dataWriter() {
        return this.writer;
    }

    @Override
    public DataReader dataReader() {
        return this.reader;
    }

    @Override
    public Router router() {
        return this.router;
    }

    private ServerConnection identifyConnection() {
        try {
            this.reader.ensureAvailable();
        }
        catch (DataReader.InsufficientDataAvailableException e) {
            throw new CloseConnectionException("No data available", e);
        }
        BufferData currentBuffer = this.reader.getBuffer(this.reader.available());
        while (true) {
            Iterator<ServerConnectionSelector> iterator;
            if (!(iterator = this.providerCandidates.iterator()).hasNext()) {
                this.socket.log(LOGGER, System.Logger.Level.DEBUG, "Could not find a suitable connection provider. initial connection buffer (may be empty if no providers exist):\n%s", new Object[]{currentBuffer.debugDataHex(false)});
                return null;
            }
            while (iterator.hasNext()) {
                ServerConnectionSelector candidate = iterator.next();
                int expectedBytes = candidate.bytesToIdentifyConnection();
                if (expectedBytes != 0 && expectedBytes >= currentBuffer.available()) continue;
                ServerConnectionSelector.Support supports = candidate.supports(currentBuffer);
                switch (supports) {
                    case SUPPORTED: {
                        return candidate.connection(this);
                    }
                    case UNSUPPORTED: {
                        iterator.remove();
                        break;
                    }
                    case UNKNOWN: {
                        if (expectedBytes == 0) break;
                        iterator.remove();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown support (" + String.valueOf((Object)supports) + ") returned from provider " + candidate.getClass().getName());
                    }
                }
                currentBuffer.rewind();
            }
            if (this.providerCandidates.isEmpty()) {
                this.socket.log(LOGGER, System.Logger.Level.DEBUG, "Could not find a suitable connection provider. initial connection buffer (may be empty if no providers exist):\n%s", new Object[]{currentBuffer.debugDataHex(true)});
                return null;
            }
            currentBuffer = this.reader.getBuffer(this.reader.available() + 1);
        }
    }

    private void closeChannel() {
        try {
            this.socket.close();
        }
        catch (Throwable e) {
            this.socket.log(LOGGER, System.Logger.Level.TRACE, "Failed to close socket on connection close", e, new Object[0]);
        }
    }
}

