/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.common.context.Context;
import io.helidon.config.ConfigException;
import io.helidon.config.metadata.Configured;
import io.helidon.config.metadata.ConfiguredOption;
import io.helidon.inject.configdriven.api.ConfigBean;
import io.helidon.webserver.ListenerConfig;
import io.helidon.webserver.ListenerConfigBlueprint;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.WebServerConfig;
import java.util.Map;
import java.util.Optional;

@Prototype.Blueprint(decorator=ServerConfigDecorator.class)
@Configured(root=true, prefix="server")
@ConfigBean(wantDefault=true)
interface WebServerConfigBlueprint
extends ListenerConfigBlueprint,
Prototype.Factory<WebServer> {
    @ConfiguredOption(value="true")
    public boolean shutdownHook();

    @ConfiguredOption
    @Option.Singular
    public Map<String, ListenerConfig> sockets();

    public Optional<Context> serverContext();

    public static class ServerConfigDecorator
    implements Prototype.BuilderDecorator<WebServerConfig.BuilderBase<?, ?>> {
        public void decorate(WebServerConfig.BuilderBase<?, ?> target) {
            if (target.sockets().containsKey("@default")) {
                throw new ConfigException("Default socket must be configured directly on server config node, or through \"ServerConfig.Builder\", not as a separated socket.");
            }
        }
    }
}

