/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http;

import io.helidon.http.ForbiddenException;
import io.helidon.http.Http;
import io.helidon.http.HttpException;
import io.helidon.http.UnauthorizedException;
import io.helidon.webserver.http.HttpSecurity;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import java.util.Arrays;

class DefaultServerSecurity
implements HttpSecurity {
    private static final System.Logger LOGGER = System.getLogger(DefaultServerSecurity.class.getName());

    DefaultServerSecurity() {
    }

    @Override
    public boolean authenticate(ServerRequest request, ServerResponse response, boolean requiredHint) throws UnauthorizedException {
        if (requiredHint) {
            throw new HttpException("Not Authenticated", Http.Status.UNAUTHORIZED_401);
        }
        return true;
    }

    @Override
    public boolean authorize(ServerRequest request, ServerResponse response, String ... roleHint) throws ForbiddenException {
        if (roleHint.length != 0) {
            if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER.log(System.Logger.Level.DEBUG, "Requested: " + String.valueOf(request.prologue()) + ", but roles required: " + Arrays.toString(roleHint));
            }
            throw new ForbiddenException("This endpoint is restricted");
        }
        return true;
    }
}

