/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http;

import io.helidon.http.DirectHandler;
import io.helidon.http.Http;
import io.helidon.http.RequestException;
import io.helidon.webserver.CloseConnectionException;
import io.helidon.webserver.http.ServerResponse;
import java.util.EnumMap;
import java.util.Map;

public class DirectHandlers {
    private static final System.Logger LOGGER = System.getLogger(DirectHandlers.class.getName());
    private final Map<DirectHandler.EventType, DirectHandler> handlers;

    private DirectHandlers(Map<DirectHandler.EventType, DirectHandler> handlers) {
        this.handlers = new EnumMap<DirectHandler.EventType, DirectHandler>(handlers);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DirectHandlers create() {
        return DirectHandlers.builder().build();
    }

    public DirectHandler handler(DirectHandler.EventType eventType) {
        return this.handlers.get(eventType);
    }

    public void handle(RequestException httpException, ServerResponse res, boolean keepAlive) {
        DirectHandler.TransportResponse response = this.handler(httpException.eventType()).handle(httpException.request(), httpException.eventType(), httpException.status(), httpException.responseHeaders(), (Throwable)httpException);
        res.status(response.status());
        response.headers().forEach(res::header);
        if (!keepAlive) {
            res.header(Http.Headers.CONNECTION_CLOSE);
        }
        if (res.isSent()) {
            throw new CloseConnectionException("Cannot send response of a simple handler, status and headers already written");
        }
        try {
            response.entity().ifPresentOrElse(res::send, res::send);
        }
        catch (IllegalStateException ex) {
            res.streamResult(response.entity().map(String::new).orElseGet(() -> httpException.getCause().getMessage()));
            throw new CloseConnectionException("Cannot send response of a simple handler, status and headers already written", ex);
        }
        Http.Status usedStatus = response.status();
        if (usedStatus == Http.Status.INTERNAL_SERVER_ERROR_500) {
            LOGGER.log(System.Logger.Level.WARNING, "Internal server error", (Throwable)httpException);
        }
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, DirectHandlers> {
        private final Map<DirectHandler.EventType, DirectHandler> handlers = new EnumMap<DirectHandler.EventType, DirectHandler>(DirectHandler.EventType.class);
        private final DirectHandler defaultHandler = DirectHandler.defaultHandler();

        private Builder() {
        }

        public DirectHandlers build() {
            for (DirectHandler.EventType value : DirectHandler.EventType.values()) {
                this.handlers.putIfAbsent(value, this.defaultHandler);
            }
            return new DirectHandlers(this.handlers);
        }

        public Builder addHandler(DirectHandler.EventType eventType, DirectHandler handler) {
            this.handlers.put(eventType, handler);
            return this;
        }

        public Builder defaults(DirectHandlers handlers) {
            handlers.handlers.forEach(this.handlers::putIfAbsent);
            return this;
        }
    }
}

