/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http;

import io.helidon.common.GenericType;
import io.helidon.common.uri.UriQuery;
import io.helidon.http.Http;
import io.helidon.http.NotFoundException;
import io.helidon.http.ServerResponseHeaders;
import io.helidon.webserver.http.spi.Sink;
import java.io.OutputStream;
import java.util.Optional;

public interface ServerResponse {
    public ServerResponse status(Http.Status var1);

    default public ServerResponse status(int status) {
        return this.status(Http.Status.create((int)status));
    }

    public Http.Status status();

    default public ServerResponse header(Http.HeaderName name, String ... values) {
        return this.header(Http.Headers.create((Http.HeaderName)name, (String[])values));
    }

    default public ServerResponse header(String name, String ... values) {
        return this.header(Http.Headers.create((String)name, (String[])values));
    }

    public ServerResponse header(Http.Header var1);

    public void send();

    public void send(byte[] var1);

    public void send(Object var1);

    default public void send(Optional<?> entity) {
        this.send(entity.orElseThrow(() -> new NotFoundException("")));
    }

    public boolean isSent();

    public OutputStream outputStream();

    public long bytesWritten();

    public ServerResponse whenSent(Runnable var1);

    public ServerResponse reroute(String var1);

    public ServerResponse reroute(String var1, UriQuery var2);

    public ServerResponse next();

    public ServerResponseHeaders headers();

    public void streamResult(String var1);

    default public void contentLength(long length) {
        this.header(Http.Headers.create((Http.HeaderName)Http.HeaderNames.CONTENT_LENGTH, (boolean)true, (boolean)false, (String[])new String[]{String.valueOf(length)}));
    }

    default public <T extends Sink<?>> T sink(GenericType<T> sinkType) {
        throw new UnsupportedOperationException("No sink available for type " + String.valueOf(sinkType));
    }
}

