/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http1;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.webserver.http1.Http1Config;
import io.helidon.webserver.http1.Http1ConnectionSelector;
import io.helidon.webserver.http1.Http1ConnectionSelectorConfigBlueprint;
import io.helidon.webserver.http1.spi.Http1Upgrader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.processor.BlueprintProcessor", trigger="io.helidon.webserver.http1.Http1ConnectionSelectorConfigBlueprint")
public interface Http1ConnectionSelectorConfig
extends Http1ConnectionSelectorConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Http1ConnectionSelectorConfig instance) {
        return (Builder)Http1ConnectionSelectorConfig.builder().from(instance);
    }

    public static Http1ConnectionSelectorConfig create() {
        return Http1ConnectionSelectorConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, Http1ConnectionSelectorConfig>
    implements io.helidon.common.Builder<Builder, Http1ConnectionSelector> {
        private Builder() {
        }

        public Http1ConnectionSelectorConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.Http1ConnectionSelectorConfigImpl(this);
        }

        public Http1ConnectionSelector build() {
            return Http1ConnectionSelector.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends Http1ConnectionSelectorConfig>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final Map<String, Http1Upgrader> upgraders = new LinkedHashMap<String, Http1Upgrader>();
        private Http1Config config;

        protected BuilderBase() {
        }

        public BUILDER from(Http1ConnectionSelectorConfig prototype) {
            this.addUpgraders(prototype.upgraders());
            this.config(prototype.config());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.addUpgraders(builder.upgraders());
            builder.config().ifPresent(this::config);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addUpgrader(Http1Upgrader upgrader) {
            Http1ConnectionSelectorConfigBlueprint.CustomMethods.addUpgrader(this, upgrader);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER upgraders(Map<? extends String, ? extends Http1Upgrader> upgraders) {
            Objects.requireNonNull(upgraders);
            this.upgraders.clear();
            this.upgraders.putAll(upgraders);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addUpgraders(Map<? extends String, ? extends Http1Upgrader> upgraders) {
            Objects.requireNonNull(upgraders);
            this.upgraders.putAll(upgraders);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER putUpgrader(String key, Http1Upgrader upgrader) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(upgrader);
            this.upgraders.put(key, upgrader);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Http1Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Consumer<Http1Config.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Http1Config.Builder builder = Http1Config.builder();
            consumer.accept(builder);
            this.config(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Supplier<? extends Http1Config> supplier) {
            Objects.requireNonNull(supplier);
            this.config(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public Map<String, Http1Upgrader> upgraders() {
            return this.upgraders;
        }

        public Optional<Http1Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "Http1ConnectionSelectorConfigBuilder{upgraders=" + String.valueOf(this.upgraders) + ",config=" + String.valueOf(this.config) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.config == null) {
                collector.fatal(this.getClass(), "Property \"config\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class Http1ConnectionSelectorConfigImpl
        implements Http1ConnectionSelectorConfig,
        Supplier<Http1ConnectionSelector> {
            private final Http1Config config;
            private final Map<String, Http1Upgrader> upgraders;

            protected Http1ConnectionSelectorConfigImpl(BuilderBase<?, ?> builder) {
                this.upgraders = Collections.unmodifiableMap(new LinkedHashMap<String, Http1Upgrader>(builder.upgraders()));
                this.config = builder.config().get();
            }

            public Http1ConnectionSelector build() {
                return Http1ConnectionSelector.create(this);
            }

            @Override
            public Http1ConnectionSelector get() {
                return this.build();
            }

            @Override
            public Map<String, Http1Upgrader> upgraders() {
                return this.upgraders;
            }

            @Override
            public Http1Config config() {
                return this.config;
            }

            public String toString() {
                return "Http1ConnectionSelectorConfig{upgraders=" + String.valueOf(this.upgraders) + ",config=" + String.valueOf(this.config) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Http1ConnectionSelectorConfig)) {
                    return false;
                }
                Http1ConnectionSelectorConfig other = (Http1ConnectionSelectorConfig)o;
                return Objects.equals(this.upgraders, other.upgraders()) && Objects.equals(this.config, other.config());
            }

            public int hashCode() {
                return Objects.hash(this.upgraders, this.config);
            }
        }
    }
}

