/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http1;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.http.RequestedUriDiscoveryContext;
import io.helidon.webserver.http1.Http1BuilderDecorator;
import io.helidon.webserver.http1.Http1ConnectionListener;
import io.helidon.webserver.spi.ProtocolConfig;
import java.util.List;

@Prototype.Blueprint(decorator=Http1BuilderDecorator.class)
@Prototype.Configured
@Prototype.Provides(value={ProtocolConfig.class})
interface Http1ConfigBlueprint
extends ProtocolConfig {
    public String name();

    @Option.Configured
    @Option.DefaultInt(value={4096})
    public int maxPrologueLength();

    @Option.Configured
    @Option.DefaultInt(value={16384})
    public int maxHeadersSize();

    @Option.Configured
    @Option.DefaultBoolean(value={true})
    public boolean validateRequestHeaders();

    @Deprecated(forRemoval=true, since="4.1.3")
    @Option.Configured
    @Option.DefaultBoolean(value={true})
    public boolean validateRequestHostHeader();

    @Option.Configured
    @Option.DefaultBoolean(value={false})
    public boolean validateResponseHeaders();

    @Option.Configured
    @Option.DefaultBoolean(value={true})
    public boolean validatePath();

    @Option.Configured(value="recv-log")
    @Option.DefaultBoolean(value={true})
    public boolean receiveLog();

    @Option.Configured
    @Option.DefaultBoolean(value={true})
    public boolean sendLog();

    @Option.Configured
    @Option.DefaultBoolean(value={false})
    public boolean continueImmediately();

    @Option.Configured
    public RequestedUriDiscoveryContext requestedUriDiscovery();

    @Option.Singular
    public List<Http1ConnectionListener> sendListeners();

    @Option.Singular
    public List<Http1ConnectionListener> receiveListeners();

    public Http1ConnectionListener compositeSendListener();

    public Http1ConnectionListener compositeReceiveListener();

    default public String type() {
        return "http_1_1";
    }
}

