/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http;

import io.helidon.http.BadRequestException;
import io.helidon.http.DirectHandler;
import io.helidon.http.HeaderValues;
import io.helidon.http.Headers;
import io.helidon.http.HttpException;
import io.helidon.http.InternalServerException;
import io.helidon.http.RequestException;
import io.helidon.webserver.CloseConnectionException;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.http.DirectTransportRequest;
import io.helidon.webserver.http.ErrorHandler;
import io.helidon.webserver.http.RoutingRequest;
import io.helidon.webserver.http.RoutingResponse;
import io.helidon.webserver.http.ServerRequest;
import java.io.UncheckedIOException;
import java.net.SocketException;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;

public final class ErrorHandlers {
    private static final System.Logger LOGGER = System.getLogger(ErrorHandlers.class.getName());
    private final IdentityHashMap<Class<? extends Throwable>, ErrorHandler<?>> errorHandlers;

    private ErrorHandlers(IdentityHashMap<Class<? extends Throwable>, ErrorHandler<?>> errorHandlers) {
        this.errorHandlers = errorHandlers;
    }

    public static ErrorHandlers create(Map<Class<? extends Throwable>, ErrorHandler<?>> errorHandlers) {
        return new ErrorHandlers(new IdentityHashMap(errorHandlers));
    }

    public String toString() {
        return "ErrorHandlers for " + String.valueOf(this.errorHandlers.keySet());
    }

    public void runWithErrorHandling(ConnectionContext ctx, RoutingRequest request, RoutingResponse response, Callable<Void> task) {
        try {
            task.call();
            if (response.hasEntity()) {
                response.commit();
            }
        }
        catch (CloseConnectionException | UncheckedIOException e) {
            throw e;
        }
        catch (RequestException e) {
            this.handleRequestException(ctx, request, response, e);
        }
        catch (BadRequestException e) {
            this.handleRequestException(ctx, request, response, RequestException.builder().message(e.getMessage()).cause((Throwable)e).type(DirectHandler.EventType.BAD_REQUEST).status(e.status()).setKeepAlive(e.keepAlive()).build());
        }
        catch (InternalServerException e) {
            Optional<ErrorHandler<?>> maybeEh;
            ErrorHandler<?> errorHandler = null;
            Throwable exception = null;
            if (e.getCause() != null && (maybeEh = this.errorHandler(e.getCause().getClass())).isPresent()) {
                errorHandler = maybeEh.get();
                exception = e.getCause();
            }
            if (errorHandler == null) {
                errorHandler = this.errorHandler(((Object)((Object)e)).getClass()).orElse(null);
                exception = e;
            }
            if (errorHandler == null) {
                this.unhandledError(ctx, request, response, exception);
            } else {
                this.handleError(ctx, request, response, exception, (ErrorHandler<Throwable>)errorHandler);
            }
        }
        catch (RuntimeException e) {
            this.handleError(ctx, request, response, e);
        }
        catch (Exception e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof SocketException) {
                SocketException se = (SocketException)throwable;
                throw new UncheckedIOException(se);
            }
            this.handleError(ctx, request, response, e);
        }
    }

    <T extends Throwable> Optional<ErrorHandler<T>> errorHandler(Class<T> exceptionClass) {
        Class<T> throwableClass = exceptionClass;
        ErrorHandler<?> errorHandler;
        while ((errorHandler = this.errorHandlers.get(throwableClass)) == null) {
            if (!Throwable.class.isAssignableFrom(throwableClass)) {
                return Optional.empty();
            }
            if (throwableClass == Throwable.class) {
                return Optional.empty();
            }
            throwableClass = throwableClass.getSuperclass();
        }
        return Optional.of(errorHandler);
    }

    private void handleRequestException(ConnectionContext ctx, ServerRequest request, RoutingResponse response, RequestException e) {
        if (!response.reset()) {
            ctx.log(LOGGER, System.Logger.Level.WARNING, "Request failed: " + String.valueOf(request.prologue()) + ", cannot send error response, as response already sent", e, new Object[0]);
            throw new CloseConnectionException("Cannot send response of an error handler, status and headers already written");
        }
        boolean keepAlive = e.keepAlive();
        if (keepAlive && !request.content().consumed()) {
            if (request.headers().contains(HeaderValues.EXPECT_100) && !request.continueSent()) {
                request.reset();
            } else {
                try {
                    request.content().consume();
                }
                catch (Exception ignored) {
                    keepAlive = request.content().consumed();
                }
            }
        }
        ctx.listenerContext().directHandlers().handle(e, response, keepAlive);
        response.commit();
    }

    private void handleError(ConnectionContext ctx, RoutingRequest request, RoutingResponse response, Throwable e) {
        this.errorHandler(e.getClass()).ifPresentOrElse(it -> this.handleError(ctx, request, response, e, (ErrorHandler<Throwable>)it), () -> this.unhandledError(ctx, request, response, e));
    }

    private void unhandledError(ConnectionContext ctx, ServerRequest request, RoutingResponse response, Throwable e) {
        if (e instanceof HttpException) {
            HttpException httpException = (HttpException)e;
            this.handleRequestException(ctx, request, response, ((RequestException.Builder)RequestException.builder().cause(e).type(DirectHandler.EventType.OTHER).message(e.getMessage()).status(httpException.status()).setKeepAlive(httpException.keepAlive()).request(DirectTransportRequest.create(request.prologue(), (Headers)request.headers())).update(it -> httpException.headers().forEach(arg_0 -> ((RequestException.Builder)it).header(arg_0)))).build());
        } else {
            this.handleRequestException(ctx, request, response, RequestException.builder().cause(e).type(DirectHandler.EventType.INTERNAL_ERROR).message(e.getMessage()).request(DirectTransportRequest.create(request.prologue(), (Headers)request.headers())).build());
        }
    }

    private void handleError(ConnectionContext ctx, RoutingRequest request, RoutingResponse response, Throwable e, ErrorHandler<Throwable> it) {
        if (!response.reset()) {
            ctx.log(LOGGER, System.Logger.Level.WARNING, "Unable to reset response for error handler.", new Object[0]);
            throw new CloseConnectionException("Cannot send response of a simple handler, status and headers already written");
        }
        try {
            it.handle(request, response, e);
            response.commit();
            if (!response.isSent()) {
                ctx.log(LOGGER, System.Logger.Level.TRACE, "Exception not handled.", e, new Object[0]);
                this.unhandledError(ctx, request, response, e);
            }
        }
        catch (Exception ex) {
            ctx.log(LOGGER, System.Logger.Level.TRACE, "Failed to handle exception.", ex, new Object[0]);
            this.unhandledError(ctx, request, response, e);
        }
    }
}

