/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.common.Builder;
import io.helidon.common.concurrency.limits.Limit;
import io.helidon.common.concurrency.limits.spi.LimitProvider;
import io.helidon.common.context.Context;
import io.helidon.common.socket.SocketOptions;
import io.helidon.common.tls.Tls;
import io.helidon.http.RequestedUriDiscoveryContext;
import io.helidon.http.encoding.ContentEncodingContext;
import io.helidon.http.media.MediaContext;
import io.helidon.webserver.ConnectionConfig;
import io.helidon.webserver.Routing;
import io.helidon.webserver.WebServerConfigSupport;
import io.helidon.webserver.http.DirectHandlers;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.spi.ProtocolConfig;
import io.helidon.webserver.spi.ProtocolConfigProvider;
import io.helidon.webserver.spi.ServerConnectionSelector;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketOption;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Prototype.Configured
@Prototype.Blueprint(decorator=WebServerConfigSupport.ListenerConfigDecorator.class)
@Prototype.CustomMethods(value=WebServerConfigSupport.ListenerCustomMethods.class)
interface ListenerConfigBlueprint {
    @Option.Configured
    @Option.Singular
    @Option.Provider(value=ProtocolConfigProvider.class)
    public List<ProtocolConfig> protocols();

    public Optional<HttpRouting.Builder> routing();

    @Option.Singular
    public List<Builder<?, ? extends Routing>> routings();

    @Option.Configured
    @Option.Default(value={"@default"})
    public String name();

    @Option.Configured
    @Option.Default(value={"0.0.0.0"})
    public String host();

    public InetAddress address();

    @Option.Configured
    @Option.DefaultInt(value={0})
    public int port();

    @Option.Configured
    @Option.DefaultInt(value={1024})
    public int backlog();

    @Option.Configured
    @Option.DefaultInt(value={-1})
    public long maxPayloadSize();

    @Option.Configured
    public Optional<Integer> receiveBufferSize();

    @Option.Configured
    @Option.DefaultInt(value={0})
    public int writeQueueLength();

    @Option.Configured
    @Option.DefaultBoolean(value={false})
    public boolean smartAsyncWrites();

    @Option.Configured
    @Option.DefaultInt(value={4096})
    public int writeBufferSize();

    @Option.Configured
    @Option.Default(value={"PT0.5S"})
    public Duration shutdownGracePeriod();

    @Option.Configured
    public Optional<ConnectionConfig> connectionConfig();

    @Option.Configured
    public Optional<Tls> tls();

    @Option.Configured
    public Optional<ContentEncodingContext> contentEncoding();

    @Option.Configured
    public Optional<MediaContext> mediaContext();

    @Option.Configured
    public SocketOptions connectionOptions();

    @Option.Configured
    @Option.DefaultInt(value={-1})
    public int maxTcpConnections();

    @Option.Configured
    @Option.DefaultInt(value={-1})
    public int maxConcurrentRequests();

    @Option.Provider(value=LimitProvider.class, discoverServices=false)
    @Option.Configured
    public Optional<Limit> concurrencyLimit();

    @Option.Configured
    @Option.Default(value={"PT5M"})
    public Duration idleConnectionTimeout();

    @Option.Configured
    @Option.Default(value={"PT2M"})
    public Duration idleConnectionPeriod();

    @Option.Configured
    @Option.DefaultInt(value={131072})
    public int maxInMemoryEntity();

    @Option.Singular
    @Option.SameGeneric
    public Map<SocketOption<?>, Object> listenerSocketOptions();

    @Option.Singular
    public List<ServerConnectionSelector> connectionSelectors();

    public Optional<DirectHandlers> directHandlers();

    public Optional<Context> listenerContext();

    @Option.Default(value={"false"})
    public boolean enableProxyProtocol();

    @Option.Configured(value="requested-uri-discovery")
    public Optional<RequestedUriDiscoveryContext> requestedUriDiscoveryContext();

    default public void configureSocket(ServerSocket socket) {
        for (Map.Entry<SocketOption<?>, Object> entry : this.listenerSocketOptions().entrySet()) {
            try {
                SocketOption<?> opt = entry.getKey();
                socket.setOption(opt, entry.getValue());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

