/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http1;

import io.helidon.common.ParserHelper;
import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.DataListener;
import io.helidon.common.buffers.DataReader;
import io.helidon.common.buffers.DataWriter;
import io.helidon.common.concurrency.limits.FixedLimit;
import io.helidon.common.concurrency.limits.Limit;
import io.helidon.common.concurrency.limits.LimitAlgorithm;
import io.helidon.common.mapper.MapperException;
import io.helidon.common.task.InterruptableTask;
import io.helidon.common.tls.TlsUtils;
import io.helidon.http.BadRequestException;
import io.helidon.http.DateTime;
import io.helidon.http.DirectHandler;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.Headers;
import io.helidon.http.HostValidator;
import io.helidon.http.HtmlEncoder;
import io.helidon.http.HttpPrologue;
import io.helidon.http.InternalServerException;
import io.helidon.http.RequestException;
import io.helidon.http.ServerRequestHeaders;
import io.helidon.http.ServerResponseHeaders;
import io.helidon.http.Status;
import io.helidon.http.WritableHeaders;
import io.helidon.http.encoding.ContentDecoder;
import io.helidon.http.encoding.ContentEncodingContext;
import io.helidon.webserver.CloseConnectionException;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.ProxyProtocolData;
import io.helidon.webserver.ServerConnectionException;
import io.helidon.webserver.http.DirectTransportRequest;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.http1.EntityStyle;
import io.helidon.webserver.http1.Http1Config;
import io.helidon.webserver.http1.Http1ConnectionListener;
import io.helidon.webserver.http1.Http1Headers;
import io.helidon.webserver.http1.Http1Prologue;
import io.helidon.webserver.http1.Http1ServerRequest;
import io.helidon.webserver.http1.Http1ServerResponse;
import io.helidon.webserver.http1.spi.Http1Upgrader;
import io.helidon.webserver.spi.ServerConnection;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.function.Supplier;

public class Http1Connection
implements ServerConnection,
InterruptableTask<Void> {
    static final byte[] CONTINUE_100 = "HTTP/1.1 100 Continue\r\n\r\n".getBytes(StandardCharsets.UTF_8);
    private static final System.Logger LOGGER = System.getLogger(Http1Connection.class.getName());
    private static final Supplier<RequestException> INVALID_SIZE_EXCEPTION_SUPPLIER = () -> RequestException.builder().type(DirectHandler.EventType.BAD_REQUEST).message("Chunk size is invalid").build();
    private final ConnectionContext ctx;
    private final Http1Config http1Config;
    private final DataWriter writer;
    private final DataReader reader;
    private final Map<String, Http1Upgrader> upgradeProviderMap;
    private final boolean canUpgrade;
    private final Http1Headers http1headers;
    private final Http1Prologue http1prologue;
    private final ContentEncodingContext contentEncodingContext;
    private final HttpRouting routing;
    private final long maxPayloadSize;
    private final Http1ConnectionListener recvListener;
    private final Http1ConnectionListener sendListener;
    private int requestId;
    private long currentEntitySize;
    private long currentEntitySizeRead;
    private volatile Thread myThread;
    private volatile boolean canRun = true;
    private volatile boolean currentlyReadingPrologue;
    private volatile ZonedDateTime lastRequestTimestamp;
    private volatile ServerConnection upgradeConnection;

    Http1Connection(ConnectionContext ctx, Http1Config http1Config, Map<String, Http1Upgrader> upgradeProviderMap) {
        this.ctx = ctx;
        this.writer = ctx.dataWriter();
        this.reader = ctx.dataReader();
        this.http1Config = http1Config;
        this.upgradeProviderMap = upgradeProviderMap;
        this.canUpgrade = !upgradeProviderMap.isEmpty();
        this.recvListener = http1Config.compositeReceiveListener();
        this.sendListener = http1Config.compositeSendListener();
        this.reader.listener((DataListener)this.recvListener, (Object)ctx);
        this.http1headers = new Http1Headers(this.reader, http1Config.maxHeadersSize(), http1Config.validateRequestHeaders());
        this.http1prologue = new Http1Prologue(this.reader, http1Config.maxPrologueLength(), http1Config.validatePath());
        this.contentEncodingContext = ctx.listenerContext().contentEncodingContext();
        this.routing = ctx.router().routing(HttpRouting.class, HttpRouting.empty());
        this.maxPayloadSize = ctx.listenerContext().config().maxPayloadSize();
        this.lastRequestTimestamp = DateTime.timestamp();
    }

    public boolean canInterrupt() {
        if (this.upgradeConnection == null) {
            return this.currentlyReadingPrologue;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handle(Limit limit) throws InterruptedException {
        this.myThread = Thread.currentThread();
        try {
            ProxyProtocolData proxyProtocolData = this.ctx.proxyProtocolData().orElse(null);
            while (this.canRun) {
                Optional token;
                this.currentlyReadingPrologue = true;
                HttpPrologue prologue = this.http1prologue.readPrologue();
                this.currentlyReadingPrologue = false;
                this.lastRequestTimestamp = DateTime.timestamp();
                this.recvListener.prologue(this.ctx, prologue);
                this.currentEntitySize = 0L;
                this.currentEntitySizeRead = 0L;
                WritableHeaders<?> headers = this.http1headers.readHeaders(prologue);
                if (this.http1Config.validateRequestHeaders()) {
                    Http1Connection.validateHostHeader(prologue, headers, this.http1Config.validateRequestHostHeader());
                }
                this.ctx.remotePeer().tlsCertificates().flatMap(TlsUtils::parseCn).ifPresent(name -> headers.set(HeaderNames.X_HELIDON_CN, new String[]{name}));
                this.recvListener.headers(this.ctx, (Headers)headers);
                if (proxyProtocolData != null) {
                    int sourcePort;
                    String sourceAddress = proxyProtocolData.sourceAddress();
                    if (!sourceAddress.isEmpty()) {
                        headers.add(HeaderNames.X_FORWARDED_FOR, new String[]{sourceAddress});
                    }
                    if ((sourcePort = proxyProtocolData.sourcePort()) != -1) {
                        headers.add(HeaderNames.X_FORWARDED_PORT, sourcePort);
                    }
                }
                if (this.canUpgrade && headers.contains(HeaderNames.UPGRADE)) {
                    if (!Http1Connection.upgradeHasEntity(headers)) {
                        ServerConnection upgradeConnection;
                        Http1Upgrader upgrader = this.upgradeProviderMap.get(headers.get(HeaderNames.UPGRADE).get());
                        if (upgrader != null && (upgradeConnection = upgrader.upgrade(this.ctx, prologue, headers)) != null) {
                            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                                LOGGER.log(System.Logger.Level.TRACE, "Connection upgrade using " + String.valueOf(upgradeConnection));
                            }
                            this.upgradeConnection = upgradeConnection;
                            upgradeConnection.handle(limit);
                            return;
                        }
                    } else {
                        this.ctx.log(LOGGER, System.Logger.Level.DEBUG, "Protocol upgrade for a request with a payload ignored", new Object[0]);
                    }
                }
                if ((token = limit.tryAcquire()).isEmpty()) {
                    this.ctx.log(LOGGER, System.Logger.Level.TRACE, "Too many concurrent requests, rejecting request and closing connection.", new Object[0]);
                    throw RequestException.builder().setKeepAlive(false).status(Status.SERVICE_UNAVAILABLE_503).type(DirectHandler.EventType.OTHER).message("Too Many Concurrent Requests").build();
                }
                LimitAlgorithm.Token permit = (LimitAlgorithm.Token)token.get();
                try {
                    this.lastRequestTimestamp = DateTime.timestamp();
                    this.route(prologue, headers);
                    permit.success();
                    this.lastRequestTimestamp = DateTime.timestamp();
                }
                catch (Throwable e) {
                    permit.dropped();
                    throw e;
                    return;
                }
            }
        }
        catch (CloseConnectionException e) {
            throw e;
        }
        catch (BadRequestException e) {
            this.handleRequestException(RequestException.builder().message(e.getMessage()).cause((Throwable)e).type(DirectHandler.EventType.BAD_REQUEST).status(e.status()).build());
            return;
        }
        catch (RequestException e) {
            this.handleRequestException(e);
            return;
        }
        catch (Throwable e) {
            this.handleRequestException(RequestException.builder().message("Internal error").type(DirectHandler.EventType.INTERNAL_ERROR).cause(e).build());
        }
    }

    @Override
    public void handle(Semaphore requestSemaphore) throws InterruptedException {
        this.handle((Limit)FixedLimit.create((Semaphore)requestSemaphore));
    }

    @Override
    public Duration idleTime() {
        if (this.upgradeConnection == null) {
            return Duration.between(this.lastRequestTimestamp, DateTime.timestamp());
        }
        return this.upgradeConnection.idleTime();
    }

    @Override
    public void close(boolean interrupt) {
        this.ctx.log(LOGGER, System.Logger.Level.TRACE, "Requested connection close, interrupt: %s", new Object[]{interrupt});
        this.canRun = false;
        if (this.upgradeConnection == null) {
            if (interrupt) {
                if (this.myThread != null) {
                    this.myThread.interrupt();
                }
            } else if (this.canInterrupt()) {
                this.myThread.interrupt();
            }
        } else {
            this.upgradeConnection.close(interrupt);
        }
    }

    void reset() {
        this.currentEntitySize = 0L;
        this.currentEntitySizeRead = 0L;
    }

    static boolean upgradeHasEntity(WritableHeaders<?> headers) {
        return headers.contains(HeaderNames.CONTENT_LENGTH) && !headers.contains(HeaderValues.CONTENT_LENGTH_ZERO) || headers.contains(HeaderValues.TRANSFER_ENCODING_CHUNKED);
    }

    static void validateHostHeader(HttpPrologue prologue, WritableHeaders<?> headers, boolean fullValidation) {
        if (fullValidation) {
            try {
                Http1Connection.doValidateHostHeader(prologue, headers);
            }
            catch (IllegalArgumentException e) {
                throw RequestException.builder().type(DirectHandler.EventType.BAD_REQUEST).status(Status.BAD_REQUEST_400).request(DirectTransportRequest.create(prologue, headers)).setKeepAlive(false).message("Invalid Host header: " + e.getMessage()).cause((Throwable)e).build();
            }
        } else {
            Http1Connection.simpleHostHeaderValidation(prologue, headers);
        }
    }

    private static void simpleHostHeaderValidation(HttpPrologue prologue, WritableHeaders<?> headers) {
        if (headers.contains(HeaderNames.HOST)) {
            String host = (String)headers.get(HeaderNames.HOST).get();
            int index = host.lastIndexOf(58);
            if (index < 1) {
                return;
            }
            if (host.charAt(host.length() - 1) == ']') {
                return;
            }
            try {
                Integer.parseInt(host.substring(index + 1));
            }
            catch (NumberFormatException e) {
                throw RequestException.builder().type(DirectHandler.EventType.BAD_REQUEST).status(Status.BAD_REQUEST_400).request(DirectTransportRequest.create(prologue, headers)).setKeepAlive(false).message("Invalid port of the host header: " + HtmlEncoder.encode((String)host.substring(index + 1))).build();
            }
        }
    }

    private static void doValidateHostHeader(HttpPrologue prologue, WritableHeaders<?> headers) {
        List hostHeaders = headers.all(HeaderNames.HOST, List::of);
        if (hostHeaders.isEmpty()) {
            throw RequestException.builder().type(DirectHandler.EventType.BAD_REQUEST).status(Status.BAD_REQUEST_400).request(DirectTransportRequest.create(prologue, headers)).setKeepAlive(false).message("Host header must be present in the request").build();
        }
        if (hostHeaders.size() > 1) {
            throw RequestException.builder().type(DirectHandler.EventType.BAD_REQUEST).status(Status.BAD_REQUEST_400).request(DirectTransportRequest.create(prologue, headers)).setKeepAlive(false).message("Only a single Host header is allowed in request").build();
        }
        String host = (String)hostHeaders.getFirst();
        if (host.isEmpty()) {
            throw RequestException.builder().type(DirectHandler.EventType.BAD_REQUEST).status(Status.BAD_REQUEST_400).request(DirectTransportRequest.create(prologue, headers)).setKeepAlive(false).message("Host header must not be empty").build();
        }
        int startLiteral = host.indexOf(91);
        int endLiteral = host.lastIndexOf(93);
        if (startLiteral == 0 && endLiteral == host.length() - 1) {
            HostValidator.validateIpLiteral((String)host);
            return;
        }
        if (startLiteral == 0 && endLiteral == -1) {
            HostValidator.validateIpLiteral((String)host);
            return;
        }
        int colon = host.lastIndexOf(58);
        if (colon == -1) {
            HostValidator.validateNonIpLiteral((String)host);
            return;
        }
        String portString = host.substring(colon + 1);
        try {
            Integer.parseInt(portString);
        }
        catch (NumberFormatException e) {
            throw RequestException.builder().type(DirectHandler.EventType.BAD_REQUEST).status(Status.BAD_REQUEST_400).request(DirectTransportRequest.create(prologue, headers)).setKeepAlive(false).message("Invalid port of the host header: " + HtmlEncoder.encode((String)portString)).build();
        }
        String hostString = host.substring(0, colon);
        if (startLiteral == 0 && endLiteral == hostString.length() - 1) {
            HostValidator.validateIpLiteral((String)hostString);
            return;
        }
        HostValidator.validateNonIpLiteral((String)hostString);
    }

    private BufferData readEntityFromPipeline(HttpPrologue prologue, WritableHeaders<?> headers) {
        if (this.currentEntitySize == -1L) {
            return this.readNextChunk(prologue, headers);
        }
        return this.readLengthEntity();
    }

    private BufferData readNextChunk(HttpPrologue prologue, WritableHeaders<?> headers) {
        String hex = this.reader.readLine();
        int chunkLength = ParserHelper.parseNonNegative((String)hex, (int)16, INVALID_SIZE_EXCEPTION_SUPPLIER);
        this.currentEntitySizeRead += (long)chunkLength;
        if (this.maxPayloadSize != -1L && this.currentEntitySizeRead > this.maxPayloadSize) {
            throw RequestException.builder().type(DirectHandler.EventType.BAD_REQUEST).status(Status.REQUEST_ENTITY_TOO_LARGE_413).request(DirectTransportRequest.create(prologue, headers)).setKeepAlive(false).build();
        }
        if (chunkLength == 0) {
            String end = this.reader.readLine();
            if (!end.isEmpty()) {
                throw RequestException.builder().type(DirectHandler.EventType.BAD_REQUEST).message("Invalid terminating chunk").build();
            }
            return null;
        }
        BufferData nextChunkData = this.reader.readBuffer(chunkLength);
        this.reader.skip(2);
        return nextChunkData;
    }

    private BufferData readLengthEntity() {
        long stillNeed = this.currentEntitySize - this.currentEntitySizeRead;
        if (stillNeed == 0L) {
            return null;
        }
        this.reader.ensureAvailable();
        int toRead = (int)Math.min((long)this.reader.available(), stillNeed);
        BufferData buffer = this.reader.readBuffer(toRead);
        this.currentEntitySizeRead += (long)toRead;
        return buffer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void route(HttpPrologue prologue, WritableHeaders<?> headers) {
        ContentDecoder decoder;
        EntityStyle entity = EntityStyle.NONE;
        if (headers.contains(HeaderValues.TRANSFER_ENCODING_CHUNKED)) {
            entity = EntityStyle.CHUNKED;
            this.currentEntitySize = -1L;
        } else if (headers.contains(HeaderNames.CONTENT_LENGTH)) {
            try {
                this.currentEntitySize = (Long)headers.get(HeaderNames.CONTENT_LENGTH).get(Long.TYPE);
                if (this.maxPayloadSize != -1L && this.currentEntitySize > this.maxPayloadSize) {
                    throw RequestException.builder().type(DirectHandler.EventType.BAD_REQUEST).status(Status.REQUEST_ENTITY_TOO_LARGE_413).request(DirectTransportRequest.create(prologue, headers)).setKeepAlive(false).build();
                }
                entity = this.currentEntitySize == 0L ? EntityStyle.NONE : EntityStyle.LENGTH;
            }
            catch (MapperException e) {
                throw RequestException.builder().type(DirectHandler.EventType.BAD_REQUEST).request(DirectTransportRequest.create(prologue, headers)).message("Content length is not a number").cause((Throwable)e).build();
            }
        }
        ++this.requestId;
        if (entity == EntityStyle.NONE) {
            Http1ServerRequest request;
            Http1ServerResponse response = new Http1ServerResponse(this.ctx, this.sendListener, this.writer, request, !(request = Http1ServerRequest.create(this.ctx, this.routing.security(), prologue, headers, this.requestId)).headers().contains(HeaderValues.CONNECTION_CLOSE), this.http1Config.validateResponseHeaders());
            this.routing.route(this.ctx, request, response);
            return;
        }
        boolean expectContinue = false;
        if (headers.contains(HeaderValues.EXPECT_100)) {
            if (this.http1Config.continueImmediately()) {
                try {
                    this.writer.writeNow(BufferData.create((byte[])CONTINUE_100));
                }
                catch (UncheckedIOException e) {
                    throw new ServerConnectionException("Failed to write continue", e);
                }
            }
            expectContinue = true;
        }
        if (this.contentEncodingContext.contentDecodingEnabled()) {
            if (headers.contains(HeaderNames.CONTENT_ENCODING)) {
                String contentEncoding = (String)headers.get(HeaderNames.CONTENT_ENCODING).get();
                if (!this.contentEncodingContext.contentDecodingSupported(contentEncoding)) throw RequestException.builder().type(DirectHandler.EventType.BAD_REQUEST).request(DirectTransportRequest.create(prologue, headers)).message("Unsupported content encoding").build();
                decoder = this.contentEncodingContext.decoder(contentEncoding);
            } else {
                decoder = ContentDecoder.NO_OP;
            }
        } else {
            if (this.http1Config.validateRequestHeaders() && headers.contains(HeaderNames.CONTENT_ENCODING)) {
                throw RequestException.builder().type(DirectHandler.EventType.BAD_REQUEST).request(DirectTransportRequest.create(prologue, headers)).message("Content-Encoding header present when content encoding is disabled").build();
            }
            decoder = ContentDecoder.NO_OP;
        }
        CountDownLatch entityReadLatch = new CountDownLatch(1);
        Http1ServerRequest request = Http1ServerRequest.create(this.ctx, this, this.http1Config, this.routing.security(), prologue, ServerRequestHeaders.create(headers), decoder, this.requestId, expectContinue, entityReadLatch, () -> this.readEntityFromPipeline(prologue, headers));
        Http1ServerResponse response = new Http1ServerResponse(this.ctx, this.sendListener, this.writer, request, !request.headers().contains(HeaderValues.CONNECTION_CLOSE), this.http1Config.validateResponseHeaders());
        this.routing.route(this.ctx, request, response);
        this.consumeEntity(request, response, entityReadLatch);
        try {
            entityReadLatch.await();
            return;
        }
        catch (InterruptedException e) {
            throw RequestException.builder().type(DirectHandler.EventType.INTERNAL_ERROR).request(DirectTransportRequest.create(prologue, headers)).message("Failed to wait for pipeline").cause((Throwable)e).build();
        }
    }

    private void consumeEntity(Http1ServerRequest request, Http1ServerResponse response, CountDownLatch entityReadLatch) {
        if (response.headers().contains(HeaderValues.CONNECTION_CLOSE) || request.content().consumed()) {
            entityReadLatch.countDown();
            return;
        }
        try {
            request.content().consume();
        }
        catch (Exception e) {
            boolean keepAlive;
            boolean bl = keepAlive = request.content().consumed() && response.headers().contains(HeaderValues.CONNECTION_KEEP_ALIVE);
            if (!response.isSent()) {
                throw new InternalServerException(e.getMessage(), (Throwable)e, keepAlive);
            }
            throw new CloseConnectionException("Failed to consume request entity, must close", e);
        }
    }

    private void handleRequestException(RequestException e) {
        DirectHandler handler = this.ctx.listenerContext().directHandlers().handler(e.eventType());
        DirectHandler.TransportResponse response = handler.handle(e.request(), e.eventType(), e.status(), e.responseHeaders(), (Throwable)e, LOGGER);
        BufferData buffer = BufferData.growing((int)128);
        ServerResponseHeaders headers = response.headers();
        headers.set(HeaderValues.CONNECTION_CLOSE);
        byte[] message = response.entity().orElse(BufferData.EMPTY_BYTES);
        headers.set(HeaderValues.create((HeaderName)HeaderNames.CONTENT_LENGTH, (String)String.valueOf(message.length)));
        Http1ServerResponse.nonEntityBytes(headers, response.status(), buffer, response.keepAlive(), this.http1Config.validateResponseHeaders());
        if (message.length != 0) {
            buffer.write(message);
        }
        this.sendListener.status(this.ctx, response.status());
        this.sendListener.headers(this.ctx, (Headers)headers);
        this.sendListener.data(this.ctx, buffer);
        try {
            this.writer.write(buffer);
        }
        catch (UncheckedIOException uioe) {
            throw new ServerConnectionException("Failed to write request exception", uioe);
        }
        if (response.status() == Status.INTERNAL_SERVER_ERROR_500) {
            LOGGER.log(System.Logger.Level.WARNING, "Internal server error", (Throwable)e);
        }
    }
}

