/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http1;

import io.helidon.common.buffers.Bytes;
import io.helidon.common.buffers.DataReader;
import io.helidon.http.DirectHandler;
import io.helidon.http.HttpPrologue;
import io.helidon.http.Method;
import io.helidon.http.RequestException;
import io.helidon.http.Status;
import io.helidon.webserver.CloseConnectionException;
import io.helidon.webserver.http.DirectTransportRequest;
import java.nio.charset.StandardCharsets;

public final class Http1Prologue {
    private static final long HTTP_1_1_LONG = 3543824036068086856L;
    private static final int GET_INT = 0x544547;
    private static final int PUT_INT = 0x545550;
    private static final int POST_INT = 1414745936;
    private static final String HTTP_1_1 = "HTTP/1.1";
    private final DataReader reader;
    private final int maxLength;
    private final boolean validatePath;

    public Http1Prologue(DataReader reader, int maxLength, boolean validatePath) {
        this.reader = reader;
        this.maxLength = maxLength;
        this.validatePath = validatePath;
    }

    public HttpPrologue readPrologue() {
        try {
            return this.doRead();
        }
        catch (DataReader.InsufficientDataAvailableException e) {
            throw new CloseConnectionException("No more data available", e);
        }
    }

    private static RequestException badRequest(String message, String method, String path, String protocol, String version) {
        Object protocolAndVersion = protocol.isBlank() && version.isBlank() ? "" : protocol + "/" + version;
        return RequestException.builder().type(DirectHandler.EventType.BAD_REQUEST).request(DirectTransportRequest.create((String)protocolAndVersion, method, path)).message(message).safeMessage(false).build();
    }

    private static Method readMethod(byte[] bytes, int index, int spaceIndex) {
        int len = spaceIndex - index;
        if (len == 3) {
            if (Http1Prologue.isGetMethod(bytes, index)) {
                return Method.GET;
            }
            if (Http1Prologue.isPutMethod(bytes, index)) {
                return Method.PUT;
            }
        } else if (len == 4 && Http1Prologue.isPostMethod(bytes, index)) {
            return Method.POST;
        }
        return Method.create((String)new String(bytes, index, len, StandardCharsets.US_ASCII));
    }

    private static boolean isGetMethod(byte[] bytes, int index) {
        int maybeGet = bytes[index] & 0xFF | (bytes[index + 1] & 0xFF) << 8 | (bytes[index + 2] & 0xFF) << 16;
        return maybeGet == 0x544547;
    }

    private static boolean isPutMethod(byte[] bytes, int index) {
        int maybeGet = bytes[index] & 0xFF | (bytes[index + 1] & 0xFF) << 8 | (bytes[index + 2] & 0xFF) << 16;
        return maybeGet == 0x545550;
    }

    private static boolean isPostMethod(byte[] bytes, int index) {
        int maybePost = bytes[index] & 0xFF | (bytes[index + 1] & 0xFF) << 8 | (bytes[index + 2] & 0xFF) << 16 | (bytes[index + 3] & 0xFF) << 24;
        return maybePost == 1414745936;
    }

    private HttpPrologue doRead() {
        int eol;
        try {
            eol = this.reader.findNewLine(this.maxLength);
        }
        catch (DataReader.IncorrectNewLineException e) {
            throw RequestException.builder().message("Invalid prologue: " + e.getMessage()).type(DirectHandler.EventType.BAD_REQUEST).cause((Throwable)e).build();
        }
        if (eol == this.maxLength) {
            throw RequestException.builder().message("Request URI too long.").type(DirectHandler.EventType.BAD_REQUEST).status(Status.REQUEST_URI_TOO_LONG_414).build();
        }
        byte[] prologueBytes = this.reader.readBytes(eol);
        this.reader.skip(2);
        int currentIndex = 0;
        int nextSpace = this.nextSpace(prologueBytes, currentIndex);
        if (nextSpace == -1) {
            throw Http1Prologue.badRequest("Invalid prologue, missing space " + this.reader.debugDataHex(), "", "", "", "");
        }
        Method method = Http1Prologue.readMethod(prologueBytes, currentIndex, nextSpace);
        currentIndex = nextSpace + 1;
        if ((nextSpace = this.nextSpace(prologueBytes, currentIndex)) == -1) {
            throw Http1Prologue.badRequest("Invalid prologue, missing space " + this.reader.debugDataHex(), method.text(), "", "", "");
        }
        String path = new String(prologueBytes, currentIndex, nextSpace - currentIndex, StandardCharsets.US_ASCII);
        currentIndex = nextSpace + 1;
        if (path.isBlank()) {
            throw Http1Prologue.badRequest("Path can't be empty", method.text(), path, "", "");
        }
        String protocol = this.readProtocol(prologueBytes, currentIndex);
        if (protocol != HTTP_1_1) {
            throw Http1Prologue.badRequest("Invalid protocol and/or version", method.text(), path, protocol, "");
        }
        try {
            return HttpPrologue.create((String)protocol, (String)"HTTP", (String)"1.1", (Method)method, (String)path, (boolean)this.validatePath);
        }
        catch (IllegalArgumentException e) {
            throw Http1Prologue.badRequest("Invalid path: " + e.getMessage(), method.text(), path, "HTTP", "1.1");
        }
    }

    private int nextSpace(byte[] prologueBytes, int currentIndex) {
        return Bytes.firstIndexOf((byte[])prologueBytes, (int)currentIndex, (int)(prologueBytes.length - 1), (byte)32);
    }

    private String readProtocol(byte[] bytes, int index) {
        long word;
        int length = bytes.length - index;
        if (length == 8 && (word = Bytes.toWord((byte[])bytes, (int)index)) == 3543824036068086856L) {
            return HTTP_1_1;
        }
        return new String(bytes, StandardCharsets.US_ASCII);
    }
}

