/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.Main;
import io.helidon.common.SerializationConfig;
import io.helidon.common.Weights;
import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.common.features.HelidonFeatures;
import io.helidon.common.features.api.HelidonFlavor;
import io.helidon.common.resumable.Resumable;
import io.helidon.common.resumable.ResumableSupport;
import io.helidon.common.tls.Tls;
import io.helidon.http.encoding.ContentEncodingContext;
import io.helidon.http.media.MediaContext;
import io.helidon.spi.HelidonShutdownHandler;
import io.helidon.webserver.ExecutorsFactory;
import io.helidon.webserver.ListenerConfig;
import io.helidon.webserver.Router;
import io.helidon.webserver.ServerFeatureContextImpl;
import io.helidon.webserver.ServerListener;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.WebServerConfig;
import io.helidon.webserver.http.DirectHandlers;
import io.helidon.webserver.spi.ServerFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;

class LoomServer
implements WebServer,
Resumable {
    private static final System.Logger LOGGER = System.getLogger(LoomServer.class.getName());
    private static final String EXIT_ON_STARTED_KEY = "exit.on.started";
    private static final AtomicInteger WEBSERVER_COUNTER = new AtomicInteger(1);
    private final Map<String, ServerListener> listeners;
    private final AtomicBoolean running = new AtomicBoolean();
    private final Lock lifecycleLock = new ReentrantLock();
    private final ExecutorService executorService;
    private final Context context;
    private final WebServerConfig serverConfig;
    private final boolean registerShutdownHook;
    private volatile HelidonShutdownHandler shutdownHandler;
    private volatile List<ListenerFuture> startFutures;
    private volatile boolean alreadyStarted = false;

    LoomServer(WebServerConfig serverConfig) {
        this.registerShutdownHook = serverConfig.shutdownHook();
        this.context = serverConfig.serverContext().orElseGet(() -> ((Context.Builder)Context.builder().id("web-" + WEBSERVER_COUNTER.getAndIncrement()).update(it -> Contexts.context().ifPresent(arg_0 -> ((Context.Builder)it).parent(arg_0)))).build());
        this.serverConfig = serverConfig;
        this.executorService = ExecutorsFactory.newLoomServerVirtualThreadPerTaskExecutor();
        HashMap<String, ListenerConfig> sockets = new HashMap<String, ListenerConfig>(serverConfig.sockets());
        sockets.put("@default", serverConfig);
        ArrayList<ServerFeature> features = new ArrayList<ServerFeature>(serverConfig.features());
        Weights.sort(features);
        ServerFeatureContextImpl featureContext = ServerFeatureContextImpl.create(serverConfig);
        for (ServerFeature feature : features) {
            featureContext.setUpFeature(feature);
        }
        Timer idleConnectionTimer = new Timer("helidon-idle-connection-timer", true);
        HashMap listenerMap = new HashMap();
        sockets.forEach((name, socketConfig) -> {
            Router socketRouter = featureContext.router((String)name);
            listenerMap.put(name, new ServerListener((String)name, (ListenerConfig)socketConfig, socketRouter, this.context, idleConnectionTimer, serverConfig.mediaContext().orElseGet(MediaContext::create), serverConfig.contentEncoding().orElseGet(ContentEncodingContext::create), serverConfig.directHandlers().orElseGet(DirectHandlers::create)));
        });
        this.listeners = Map.copyOf(listenerMap);
        ResumableSupport.get().register((Resumable)this);
    }

    public WebServerConfig prototype() {
        return this.serverConfig;
    }

    @Override
    public WebServer start() {
        HelidonFeatures.flavor((HelidonFlavor)HelidonFlavor.SE);
        HelidonFeatures.print((HelidonFlavor)HelidonFlavor.SE, (String)"4.2.5", (boolean)false);
        try {
            this.lifecycleLock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Webserver start was interrupted");
        }
        try {
            if (this.running.compareAndSet(false, true)) {
                if (this.alreadyStarted) {
                    this.running.set(false);
                    throw new IllegalStateException("Server cannot be stopped and restarted, please create a new server");
                }
                this.alreadyStarted = true;
                this.startIt();
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
        return this;
    }

    @Override
    public WebServer stop() {
        try {
            this.lifecycleLock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Webserver stop was interrupted", e);
        }
        try {
            if (this.running.get()) {
                this.stopIt();
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
        return this;
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public int port(String socketName) {
        if (!this.running.get()) {
            return -1;
        }
        ServerListener listener = this.listeners.get(socketName);
        return listener == null ? -1 : listener.port();
    }

    @Override
    public boolean hasTls(String socketName) {
        ServerListener listener = this.listeners.get(socketName);
        return listener != null && listener.hasTls();
    }

    @Override
    public void reloadTls(String socketName, Tls tls) {
        ServerListener listener = this.listeners.get(socketName);
        if (listener == null) {
            throw new IllegalArgumentException("Cannot reload TLS on socket " + socketName + " since this socket does not exist");
        }
        listener.reloadTls(tls);
    }

    @Override
    public Context context() {
        return this.context;
    }

    private void stopIt() {
        for (ServerListener listener : this.listeners.values()) {
            listener.stop();
        }
        this.running.set(false);
        LOGGER.log(System.Logger.Level.INFO, "Helidon WebServer stopped all channels.");
        this.deregisterShutdownHook();
    }

    private void startIt() {
        long now = System.currentTimeMillis();
        SerializationConfig.configureRuntime();
        boolean result = this.parallel("start", ServerListener::start);
        if (!result) {
            LOGGER.log(System.Logger.Level.ERROR, "Helidon WebServer failed to start, shutting down");
            this.parallel("stop", ServerListener::stop);
            if (this.startFutures != null) {
                this.startFutures.forEach(future -> future.future().cancel(true));
            }
            this.running.set(false);
            return;
        }
        if (this.registerShutdownHook) {
            this.registerShutdownHook();
        }
        now = System.currentTimeMillis() - now;
        long uptime = ResumableSupport.get().uptime();
        LOGGER.log(System.Logger.Level.INFO, "Started all channels in " + now + " milliseconds. " + uptime + " milliseconds since JVM startup. Java " + String.valueOf(Runtime.version()));
        this.fireAfterStart();
        if ("!".equals(System.getProperty(EXIT_ON_STARTED_KEY))) {
            LOGGER.log(System.Logger.Level.INFO, String.format("Exiting, -D%s set.", EXIT_ON_STARTED_KEY));
            Context ctx = Contexts.context().orElseGet(Contexts::globalContext);
            Thread.ofPlatform().daemon(false).name("Helidon system exit thread").start(() -> Contexts.runInContext((Context)ctx, () -> System.exit(0)));
        }
    }

    private void fireAfterStart() {
        this.listeners.values().forEach(l -> l.router().afterStart(this));
    }

    private void registerShutdownHook() {
        this.shutdownHandler = new ServerShutdownHandler(this.listeners, this.startFutures, this.running, this.context.id());
        Main.addShutdownHandler((HelidonShutdownHandler)this.shutdownHandler);
    }

    private void deregisterShutdownHook() {
        if (this.shutdownHandler != null) {
            Main.removeShutdownHandler((HelidonShutdownHandler)this.shutdownHandler);
            this.shutdownHandler = null;
        }
    }

    private boolean parallel(String taskName, Consumer<ServerListener> task) {
        boolean result = true;
        LinkedList<ListenerFuture> futures = new LinkedList<ListenerFuture>();
        for (ServerListener listener : this.listeners.values()) {
            futures.add(new ListenerFuture(listener, this.executorService.submit(() -> Contexts.runInContext((Context)this.context, () -> {
                Thread.currentThread().setName(taskName + " " + String.valueOf(listener));
                task.accept(listener);
            }))));
        }
        for (ListenerFuture listenerFuture : futures) {
            try {
                listenerFuture.future().get();
            }
            catch (InterruptedException e) {
                LOGGER.log(System.Logger.Level.ERROR, "Failed to start listener, interrupted: " + String.valueOf(listenerFuture.listener.configuredAddress()), (Throwable)e);
                result = false;
            }
            catch (ExecutionException e) {
                LOGGER.log(System.Logger.Level.ERROR, "Failed to start listener: " + String.valueOf(listenerFuture.listener.configuredAddress()), (Throwable)e);
                result = false;
            }
        }
        this.startFutures = futures;
        return result;
    }

    public void suspend() {
        try {
            this.lifecycleLock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Interrupted during snapshot checkpoint.", e);
        }
        try {
            if (this.running.get()) {
                for (ServerListener listener : this.listeners.values()) {
                    listener.suspend();
                }
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        long now = System.currentTimeMillis();
        try {
            this.lifecycleLock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Interrupted during snapshot restore.", e);
        }
        try {
            if (this.running.get()) {
                for (ServerListener listener : this.listeners.values()) {
                    listener.resume();
                }
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
        now = System.currentTimeMillis() - now;
        LOGGER.log(System.Logger.Level.INFO, "Restored all channels in " + now + " milliseconds. " + ResumableSupport.get().uptimeSinceResume() + " milliseconds since JVM snapshot restore. Java " + String.valueOf(Runtime.version()));
    }

    private static final class ServerShutdownHandler
    implements HelidonShutdownHandler {
        private final Map<String, ServerListener> listeners;
        private final List<ListenerFuture> startFutures;
        private final AtomicBoolean running;
        private final String id;

        private ServerShutdownHandler(Map<String, ServerListener> listeners, List<ListenerFuture> startFutures, AtomicBoolean running, String id) {
            this.listeners = listeners;
            this.startFutures = startFutures;
            this.running = running;
            this.id = id;
        }

        public void shutdown() {
            this.listeners.values().forEach(ServerListener::stop);
            if (this.startFutures != null) {
                this.startFutures.forEach(future -> future.future().cancel(true));
            }
            this.running.set(false);
        }

        public String toString() {
            return "WebServer shutdown handler for id: " + this.id;
        }
    }

    private record ListenerFuture(ServerListener listener, Future<?> future) {
    }
}

