/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.builder.api.RuntimeType;
import io.helidon.common.context.Context;
import io.helidon.common.tls.Tls;
import io.helidon.webserver.LoomServer;
import io.helidon.webserver.WebServerConfig;
import java.util.function.Consumer;

@RuntimeType.PrototypedBy(value=WebServerConfig.class)
public interface WebServer
extends RuntimeType.Api<WebServerConfig> {
    public static final String DEFAULT_SOCKET_NAME = "@default";

    public static WebServer create(WebServerConfig serverConfig) {
        return new LoomServer(serverConfig);
    }

    public static WebServer create(Consumer<WebServerConfig.Builder> builderConsumer) {
        WebServerConfig.Builder b = WebServerConfig.builder();
        builderConsumer.accept(b);
        return b.build();
    }

    public static WebServerConfig.Builder builder() {
        return WebServerConfig.builder();
    }

    public WebServer start();

    public WebServer stop();

    public boolean isRunning();

    default public int port() {
        return this.port(DEFAULT_SOCKET_NAME);
    }

    public int port(String var1);

    default public boolean hasTls() {
        return this.hasTls(DEFAULT_SOCKET_NAME);
    }

    public Context context();

    public boolean hasTls(String var1);

    default public void reloadTls(Tls tls) {
        this.reloadTls(DEFAULT_SOCKET_NAME, tls);
    }

    public void reloadTls(String var1, Tls var2);
}

