/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Builder;
import io.helidon.common.config.Config;
import io.helidon.common.socket.SocketOptions;
import io.helidon.config.ConfigException;
import io.helidon.http.RequestedUriDiscoveryContext;
import io.helidon.webserver.ListenerConfig;
import io.helidon.webserver.Routing;
import io.helidon.webserver.WebServerConfig;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.spi.ServerFeature;
import java.net.InetAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

class WebServerConfigSupport {
    WebServerConfigSupport() {
    }

    static class RoutingsDecorator
    implements Prototype.OptionDecorator<ListenerConfig.BuilderBase<?, ?>, Builder<?, ? extends Routing>> {
        RoutingsDecorator() {
        }

        public void decorate(ListenerConfig.BuilderBase<?, ?> builder, Builder<?, ? extends Routing> optionValue) {
            if (optionValue instanceof HttpRouting.Builder) {
                HttpRouting.Builder httpRouting = (HttpRouting.Builder)optionValue;
                if (builder.routings().isEmpty()) {
                    builder.routing(httpRouting);
                } else {
                    throw new IllegalStateException("HTTP routing is configured both through routing() and routings() method. This would end up with two distinct HTTP routings for a single listener, which is not allowed.");
                }
            }
        }

        public void decorateSetList(ListenerConfig.BuilderBase<?, ?> builder, List<Builder<?, ? extends Routing>> optionValues) {
            for (Builder<?, Routing> builder2 : optionValues) {
                if (!(builder2 instanceof HttpRouting.Builder)) continue;
                HttpRouting.Builder httpRouting = (HttpRouting.Builder)builder2;
                if (builder.routing().isEmpty()) {
                    builder.routing(httpRouting);
                    continue;
                }
                if (builder.routing().get() == httpRouting) continue;
                throw new IllegalStateException("HTTP routing is configured both through routing() and routings() method. This would end up with two distinct HTTP routings for a single listener, which is not allowed.");
            }
        }

        public void decorateAddList(ListenerConfig.BuilderBase<?, ?> builder, List<Builder<?, ? extends Routing>> optionValues) {
            this.decorateSetList(builder, optionValues);
        }
    }

    static class ListenerCustomMethods {
        ListenerCustomMethods() {
        }

        @Prototype.BuilderMethod
        static void routing(ListenerConfig.BuilderBase<?, ?> builder, Consumer<HttpRouting.Builder> builderConsumer) {
            HttpRouting.Builder routingBuilder = HttpRouting.builder();
            builderConsumer.accept(routingBuilder);
            builder.routing(routingBuilder);
        }
    }

    static class ListenerConfigDecorator
    implements Prototype.BuilderDecorator<ListenerConfig.BuilderBase<?, ?>> {
        ListenerConfigDecorator() {
        }

        public void decorate(ListenerConfig.BuilderBase<?, ?> target) {
            Map<SocketOption<?>, Object> socketOptions;
            Config config;
            String name = target.name();
            if (name == null && target.config().isPresent() && (config = target.config().get()).exists()) {
                target.name((String)config.get("name").asString().orElse((Object)config.name()));
            }
            if ((name = target.name()) == null) {
                target.name("@default");
            }
            if (target.connectionOptions().isEmpty()) {
                target.connectionOptions(SocketOptions.create());
            }
            if (target.address().isEmpty()) {
                try {
                    target.address(InetAddress.getByName(target.host()));
                }
                catch (UnknownHostException e) {
                    throw new IllegalArgumentException("Failed to get address from host: " + target.host(), e);
                }
            }
            if (!(socketOptions = target.listenerSocketOptions()).containsKey(StandardSocketOptions.SO_REUSEADDR)) {
                target.putListenerSocketOption(StandardSocketOptions.SO_REUSEADDR, true);
            }
            if (!socketOptions.containsKey(StandardSocketOptions.SO_RCVBUF)) {
                target.putListenerSocketOption(StandardSocketOptions.SO_RCVBUF, 4096);
            }
            if (target.requestedUriDiscoveryContext().isEmpty()) {
                target.requestedUriDiscoveryContext(RequestedUriDiscoveryContext.builder().socketId(target.name()).build());
            }
        }
    }

    public static class ServerConfigDecorator
    implements Prototype.BuilderDecorator<WebServerConfig.BuilderBase<?, ?>> {
        private static final System.Logger LOGGER = System.getLogger(ServerConfigDecorator.class.getName());

        public void decorate(WebServerConfig.BuilderBase<?, ?> target) {
            if (target.sockets().containsKey("@default")) {
                throw new ConfigException("Default socket must be configured directly on server config node, or through \"ServerConfig.Builder\", not as a separated socket.");
            }
            if (target.namedRoutings().containsKey("@default")) {
                throw new ConfigException("Default routing must be configured directly on server config node, or through \"ServerConfig.Builder\", not as a named routing.");
            }
            List<ServerFeature> features = target.features();
            ArrayList<ServerFeature> uniqueFeatures = new ArrayList<ServerFeature>();
            HashSet<FeatureId> registeredFeatures = new HashSet<FeatureId>();
            for (ServerFeature feature : features) {
                if (registeredFeatures.add(new FeatureId(feature.type(), feature.name()))) {
                    uniqueFeatures.add(feature);
                    continue;
                }
                if (!LOGGER.isLoggable(System.Logger.Level.DEBUG)) continue;
                LOGGER.log(System.Logger.Level.DEBUG, "Feature (type, name): (" + feature.type() + ", " + feature.name() + ") is already registered with server, and will be ignored (probably one registered through builder, the other through service loader. Builder wins.");
            }
            target.features(uniqueFeatures);
            Optional<HttpRouting.Builder> routing = target.routing();
            Optional<HttpRouting.Builder> httpRouting = target.routings().stream().filter(it -> it instanceof HttpRouting.Builder).map(HttpRouting.Builder.class::cast).findFirst();
            if (routing.isPresent() && httpRouting.isPresent() && routing.get() != httpRouting.get()) {
                throw new IllegalStateException("HTTP routing is configured both through a Builder.routing(...) and builder.routings(...), which is not compatible.");
            }
        }

        record FeatureId(String type, String name) {
        }
    }

    static class CustomMethods {
        CustomMethods() {
        }

        @Prototype.BuilderMethod
        static void routing(WebServerConfig.BuilderBase<?, ?> builder, String socket, Consumer<HttpRouting.Builder> consumer) {
            HttpRouting.Builder routingBuilder = HttpRouting.builder();
            consumer.accept(routingBuilder);
            builder.addNamedRouting(socket, routingBuilder);
        }

        @Prototype.BuilderMethod
        static void routing(WebServerConfig.BuilderBase<?, ?> builder, String socket, HttpRouting.Builder routing) {
            builder.addNamedRouting(socket, routing);
        }
    }
}

