/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.Default;
import io.helidon.config.Configuration;
import io.helidon.service.registry.Service;
import io.helidon.webserver.LoomServer;

@Service.Singleton
@Service.RunLevel(value=50.0)
class WebServerStarterService {
    private static final System.Logger LOGGER = System.getLogger(WebServerStarterService.class.getName());
    private final LoomServer server;
    private final boolean ignoreIncubating;

    WebServerStarterService(LoomServer server, @Default.Boolean(value={false}) @Configuration.Value(value="declarative.ignore-incubating") boolean ignoreIncubating) {
        this.server = server;
        this.ignoreIncubating = ignoreIncubating;
    }

    @Service.PostConstruct
    void postConstruct() {
        this.server.start();
        if (!this.ignoreIncubating) {
            LOGGER.log(System.Logger.Level.WARNING, "Helidon WebServer is starting through Helidon Declarative. This is currently an incubating feature (and as such it may be changed including backward incompatible changes). This warning can be disabled by setting configuration option 'declarative.ignore-incubating' to true");
        }
    }

    @Service.PreDestroy
    void preDestroy() {
        if (this.server != null) {
            this.server.stop();
        }
    }
}

