/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http;

import io.helidon.common.Weighted;
import io.helidon.common.Weights;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.service.registry.Interception;
import io.helidon.service.registry.InterceptionContext;
import io.helidon.service.registry.Qualifier;
import io.helidon.service.registry.Service;
import io.helidon.service.registry.ServiceDescriptor;
import io.helidon.service.registry.ServiceInstance;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpEntryPoint;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Service.Singleton
class HttpEntryPointsImpl
implements HttpEntryPoint.EntryPoints {
    private final boolean noInterceptors;
    private final List<HttpEntryPoint.Interceptor> interceptors;

    @Service.Inject
    HttpEntryPointsImpl(List<ServiceInstance<Interception.EntryPointInterceptor>> entryPointInterceptors, List<ServiceInstance<HttpEntryPoint.Interceptor>> httpEntryPointInterceptors) {
        this.noInterceptors = entryPointInterceptors.isEmpty() && httpEntryPointInterceptors.isEmpty();
        this.interceptors = HttpEntryPointsImpl.merge(entryPointInterceptors, httpEntryPointInterceptors);
    }

    @Override
    public Handler handler(ServiceDescriptor<?> descriptor, Set<Qualifier> typeQualifiers, List<Annotation> typeAnnotations, TypedElementInfo methodInfo, Handler actualHandler) {
        if (this.noInterceptors) {
            return actualHandler;
        }
        InterceptionContext ctx = ((InterceptionContext.Builder)((InterceptionContext.Builder)((InterceptionContext.Builder)InterceptionContext.builder().typeAnnotations(typeAnnotations)).elementInfo(methodInfo)).serviceInfo(descriptor)).build();
        return new EntryPointHandler(ctx, this.interceptors, actualHandler);
    }

    private static List<HttpEntryPoint.Interceptor> merge(List<ServiceInstance<Interception.EntryPointInterceptor>> entryPoints, List<ServiceInstance<HttpEntryPoint.Interceptor>> httpEntryPoints) {
        ArrayList merged = new ArrayList();
        httpEntryPoints.stream().map(it -> new WeightedInterceptor((HttpEntryPoint.Interceptor)it.get(), it.weight())).forEach(merged::add);
        entryPoints.stream().map(it -> new WeightedInterceptor(HttpEntryPointsImpl.toHttpEntryPoint((Interception.EntryPointInterceptor)it.get()), it.weight())).forEach(merged::add);
        Weights.sort(merged);
        return merged.stream().map(WeightedInterceptor::interceptor).collect(Collectors.toUnmodifiableList());
    }

    private static HttpEntryPoint.Interceptor toHttpEntryPoint(Interception.EntryPointInterceptor entryPointInterceptor) {
        return (invocationContext, chain, request, response) -> entryPointInterceptor.proceed(invocationContext, (Interception.Interceptor.Chain)chain, new Object[]{request, response});
    }

    private static class EntryPointHandler
    implements Handler {
        private final InterceptionContext ctx;
        private final List<HttpEntryPoint.Interceptor> interceptors;
        private final Handler actualHandler;

        private EntryPointHandler(InterceptionContext ctx, List<HttpEntryPoint.Interceptor> interceptors, Handler actualHandler) {
            this.ctx = ctx;
            this.interceptors = interceptors;
            this.actualHandler = actualHandler;
        }

        @Override
        public void handle(ServerRequest req, ServerResponse res) throws Exception {
            this.createChain().proceed(req, res);
        }

        private HttpEntryPoint.Interceptor.Chain createChain() {
            return new Invocation(this.ctx, this.interceptors, this.actualHandler);
        }
    }

    private record WeightedInterceptor(HttpEntryPoint.Interceptor interceptor, double weight) implements Weighted
    {
    }

    private static class Invocation
    implements HttpEntryPoint.Interceptor.Chain {
        private final InterceptionContext ctx;
        private final List<HttpEntryPoint.Interceptor> interceptors;
        private final Handler actualHandler;
        private int interceptorPos;

        private Invocation(InterceptionContext ctx, List<HttpEntryPoint.Interceptor> interceptors, Handler actualHandler) {
            this.ctx = ctx;
            this.interceptors = interceptors;
            this.actualHandler = actualHandler;
        }

        @Override
        public void proceed(ServerRequest request, ServerResponse response) throws Exception {
            if (this.interceptorPos < this.interceptors.size()) {
                HttpEntryPoint.Interceptor interceptor = this.interceptors.get(this.interceptorPos);
                ++this.interceptorPos;
                try {
                    interceptor.proceed(this.ctx, this, request, response);
                    return;
                }
                catch (Exception e) {
                    --this.interceptorPos;
                    throw e;
                }
            }
            this.actualHandler.handle(request, response);
        }

        public String toString() {
            return String.valueOf(this.ctx.elementInfo());
        }
    }
}

