/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http1;

import io.helidon.http.HttpPrologue;
import io.helidon.http.Method;
import io.helidon.http.PathMatcher;
import io.helidon.http.PathMatchers;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpRoute;
import java.util.Optional;
import java.util.function.Predicate;

public class Http1Route
implements HttpRoute {
    private final Predicate<Method> methodPredicate;
    private final PathMatcher pathMatcher;
    private final Handler handler;

    private Http1Route(Predicate<Method> methodPredicate, PathMatcher pathMatcher, Handler handler) {
        this.methodPredicate = methodPredicate;
        this.pathMatcher = pathMatcher;
        this.handler = handler;
    }

    public static Http1Route route(Method method, String path, Handler handler) {
        return new Http1Route((Predicate<Method>)Method.predicate((Method[])new Method[]{method}), PathMatchers.create((String)path), handler);
    }

    @Override
    public PathMatchers.MatchResult accepts(HttpPrologue prologue) {
        if (!prologue.protocolVersion().equals("1.1")) {
            return PathMatchers.MatchResult.notAccepted();
        }
        if (!this.methodPredicate.test(prologue.method())) {
            return PathMatchers.MatchResult.notAccepted();
        }
        return this.pathMatcher.match(prologue.uriPath());
    }

    @Override
    public Optional<PathMatcher> pathMatcher() {
        return Optional.of(this.pathMatcher);
    }

    @Override
    public Handler handler() {
        return this.handler;
    }

    @Override
    public void beforeStart() {
        this.handler.beforeStart();
    }

    @Override
    public void afterStart(WebServer webServer) {
        this.handler.afterStart(webServer);
    }

    @Override
    public void afterStop() {
        this.handler.afterStop();
    }
}

