/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http1;

import io.helidon.common.LazyValue;
import io.helidon.common.buffers.BufferData;
import io.helidon.common.concurrency.limits.LimitAlgorithm;
import io.helidon.http.Headers;
import io.helidon.http.HttpPrologue;
import io.helidon.http.ServerRequestHeaders;
import io.helidon.http.Status;
import io.helidon.http.encoding.ContentDecoder;
import io.helidon.http.media.ReadableEntity;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.http.HttpSecurity;
import io.helidon.webserver.http.ServerRequestEntity;
import io.helidon.webserver.http1.Http1Config;
import io.helidon.webserver.http1.Http1Connection;
import io.helidon.webserver.http1.Http1ServerRequest;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

final class Http1ServerRequestWithEntity
extends Http1ServerRequest {
    private static final System.Logger LOGGER = System.getLogger(Http1ServerRequestWithEntity.class.getName());
    private final LazyValue<ReadableEntity> entity;
    private final ConnectionContext ctx;
    private final Http1Connection connection;
    private final boolean expectContinue;
    private final boolean continueImmediately;
    private boolean continueSent;
    private UnaryOperator<InputStream> streamFilter = UnaryOperator.identity();

    Http1ServerRequestWithEntity(ConnectionContext ctx, Http1Connection connection, Http1Config http1Config, HttpSecurity security, HttpPrologue prologue, ServerRequestHeaders headers, ContentDecoder decoder, int requestId, boolean expectContinue, CountDownLatch entityReadLatch, Supplier<BufferData> readEntityFromPipeline, LimitAlgorithm.Outcome limitOutcome) {
        super(ctx, security, prologue, (Headers)headers, requestId, limitOutcome);
        this.ctx = ctx;
        this.connection = connection;
        this.expectContinue = expectContinue;
        this.continueImmediately = http1Config.continueImmediately();
        this.continueSent = this.continueImmediately || !expectContinue;
        this.entity = LazyValue.create(() -> ServerRequestEntity.create(this::trySend100, this.streamFilter, decoder, arg_0 -> Http1ServerRequestWithEntity.lambda$new$0((Supplier)readEntityFromPipeline, arg_0), entityReadLatch::countDown, headers, ctx.listenerContext().mediaContext()));
    }

    @Override
    public ReadableEntity content() {
        return (ReadableEntity)this.entity.get();
    }

    @Override
    public void reset() {
        if (!this.continueSent) {
            this.connection.reset();
        }
    }

    @Override
    public boolean continueSent() {
        return this.continueSent;
    }

    @Override
    public void streamFilter(UnaryOperator<InputStream> filterFunction) {
        Objects.requireNonNull(filterFunction);
        UnaryOperator<InputStream> current = this.streamFilter;
        this.streamFilter = it -> (InputStream)filterFunction.apply((InputStream)current.apply((InputStream)it));
    }

    @Override
    public String toString() {
        return super.toString() + " with entity";
    }

    private void trySend100(boolean drain) {
        if (!this.continueImmediately && this.expectContinue && !drain) {
            BufferData buffer = BufferData.create((byte[])Http1Connection.CONTINUE_100);
            if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                this.ctx.log(LOGGER, System.Logger.Level.DEBUG, "send: status %s", new Object[]{Status.CONTINUE_100});
                this.ctx.log(LOGGER, System.Logger.Level.DEBUG, "send %n%s", new Object[]{buffer.debugDataHex()});
            }
            this.ctx.dataWriter().writeNow(buffer);
            this.continueSent = true;
        }
    }

    private static /* synthetic */ BufferData lambda$new$0(Supplier readEntityFromPipeline, Integer it) {
        return (BufferData)readEntityFromPipeline.get();
    }
}

