/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.observe.health;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.config.Config;
import io.helidon.health.HealthCheck;
import io.helidon.health.HealthCheckType;
import io.helidon.health.spi.HealthCheckProvider;
import io.helidon.http.media.EntityWriter;
import io.helidon.http.media.jsonp.JsonpSupport;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpRules;
import io.helidon.webserver.http.HttpService;
import io.helidon.webserver.observe.health.HealthHandler;
import io.helidon.webserver.observe.health.SingleCheckHandler;
import io.helidon.webserver.servicecommon.HelidonFeatureSupport;
import jakarta.json.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;

public class HealthFeature
extends HelidonFeatureSupport {
    private static final System.Logger LOGGER = System.getLogger(HealthFeature.class.getName());
    private final boolean details;
    private final List<HealthCheck> all;
    private final List<HealthCheck> ready;
    private final List<HealthCheck> live;
    private final List<HealthCheck> start;
    private final boolean enabled;

    private HealthFeature(Builder builder) {
        super(LOGGER, (HelidonFeatureSupport.Builder)builder, "health");
        this.details = builder.details;
        this.enabled = builder.enabled;
        this.all = new ArrayList<HealthCheck>(builder.allChecks);
        this.ready = new ArrayList<HealthCheck>(builder.readyChecks);
        this.live = new ArrayList<HealthCheck>(builder.liveChecks);
        this.start = new ArrayList<HealthCheck>(builder.startChecks);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static HealthFeature create(HealthCheck ... healthChecks) {
        return ((Builder)HealthFeature.builder().useSystemServices(false).update(it -> {
            for (HealthCheck healthCheck : healthChecks) {
                it.addCheck(healthCheck);
            }
        })).build();
    }

    public Optional<HttpService> service() {
        if (this.enabled) {
            return Optional.of(this::configureRoutes);
        }
        return Optional.empty();
    }

    protected void context(String componentPath) {
        super.context(componentPath);
    }

    private void configureRoutes(HttpRules rules) {
        EntityWriter entityWriter = JsonpSupport.serverResponseWriter();
        rules.get("/", new Handler[]{new HealthHandler((EntityWriter<JsonObject>)entityWriter, this.details, this.all)}).get("/" + HealthCheckType.READINESS.defaultEndpoint(), new Handler[]{new HealthHandler((EntityWriter<JsonObject>)entityWriter, this.details, this.ready)}).get("/" + HealthCheckType.LIVENESS.defaultEndpoint(), new Handler[]{new HealthHandler((EntityWriter<JsonObject>)entityWriter, this.details, this.live)}).get("/" + HealthCheckType.STARTUP.defaultEndpoint(), new Handler[]{new HealthHandler((EntityWriter<JsonObject>)entityWriter, this.details, this.start)}).get("/" + HealthCheckType.READINESS.defaultEndpoint() + "/{name}", new Handler[]{new SingleCheckHandler((EntityWriter<JsonObject>)entityWriter, this.details, this.ready)}).get("/" + HealthCheckType.LIVENESS.defaultEndpoint() + "/{name}", new Handler[]{new SingleCheckHandler((EntityWriter<JsonObject>)entityWriter, this.details, this.live)}).get("/" + HealthCheckType.STARTUP.defaultEndpoint() + "/{name}", new Handler[]{new SingleCheckHandler((EntityWriter<JsonObject>)entityWriter, this.details, this.start)}).get("/check/{name}", new Handler[]{new SingleCheckHandler((EntityWriter<JsonObject>)entityWriter, this.details, this.all)}).head("/", new Handler[]{new HealthHandler((EntityWriter<JsonObject>)entityWriter, false, this.all)}).head("/" + HealthCheckType.READINESS.defaultEndpoint(), new Handler[]{new HealthHandler((EntityWriter<JsonObject>)entityWriter, false, this.ready)}).head("/" + HealthCheckType.LIVENESS.defaultEndpoint(), new Handler[]{new HealthHandler((EntityWriter<JsonObject>)entityWriter, false, this.live)}).head("/" + HealthCheckType.STARTUP.defaultEndpoint(), new Handler[]{new HealthHandler((EntityWriter<JsonObject>)entityWriter, false, this.start)}).head("/" + HealthCheckType.READINESS.defaultEndpoint() + "/{name}", new Handler[]{new SingleCheckHandler((EntityWriter<JsonObject>)entityWriter, false, this.ready)}).head("/" + HealthCheckType.LIVENESS.defaultEndpoint() + "/{name}", new Handler[]{new SingleCheckHandler((EntityWriter<JsonObject>)entityWriter, false, this.live)}).head("/" + HealthCheckType.STARTUP.defaultEndpoint() + "/{name}", new Handler[]{new SingleCheckHandler((EntityWriter<JsonObject>)entityWriter, false, this.start)}).head("/check/{name}", new Handler[]{new SingleCheckHandler((EntityWriter<JsonObject>)entityWriter, false, this.all)});
    }

    public static class Builder
    extends HelidonFeatureSupport.Builder<Builder, HealthFeature> {
        private final HelidonServiceLoader.Builder<HealthCheckProvider> providers = HelidonServiceLoader.builder(ServiceLoader.load(HealthCheckProvider.class));
        private final List<HealthCheck> allChecks = new ArrayList<HealthCheck>();
        private final List<HealthCheck> readyChecks = new ArrayList<HealthCheck>();
        private final List<HealthCheck> liveChecks = new ArrayList<HealthCheck>();
        private final List<HealthCheck> startChecks = new ArrayList<HealthCheck>();
        private Config config = Config.empty();
        private boolean enabled = true;
        private boolean details = false;

        Builder() {
            super("health");
        }

        public HealthFeature build() {
            this.providers.build().asList().stream().map(provider -> provider.healthChecks(this.config)).flatMap(Collection::stream).forEach(it -> this.addCheck((HealthCheck)it, it.type()));
            return new HealthFeature(this);
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder details(boolean details) {
            this.details = details;
            return this;
        }

        public Builder config(Config config) {
            super.config(config);
            this.config = config;
            config.get("enabled").asBoolean().ifPresent(this::enabled);
            config.get("details").asBoolean().ifPresent(this::details);
            return this;
        }

        public Builder addCheck(HealthCheck healthCheck) {
            return this.addCheck(healthCheck, healthCheck.type());
        }

        public Builder addCheck(HealthCheck healthCheck, HealthCheckType type) {
            this.allChecks.add(healthCheck);
            List<HealthCheck> checks = switch (type) {
                default -> throw new MatchException(null, null);
                case HealthCheckType.READINESS -> this.readyChecks;
                case HealthCheckType.LIVENESS -> this.liveChecks;
                case HealthCheckType.STARTUP -> this.startChecks;
            };
            checks.add(healthCheck);
            return this;
        }

        public Builder useSystemServices(boolean useServices) {
            this.providers.useSystemServiceLoader(useServices);
            return this;
        }
    }
}

