/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.observe.health;

import io.helidon.common.config.Config;
import io.helidon.health.HealthCheck;
import io.helidon.http.Http;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.observe.health.HealthFeature;
import io.helidon.webserver.observe.spi.ObserveProvider;
import java.util.function.Supplier;

public class HealthObserveProvider
implements ObserveProvider {
    private final HealthFeature explicitService;

    @Deprecated
    public HealthObserveProvider() {
        this(null);
    }

    private HealthObserveProvider(HealthFeature explicitService) {
        this.explicitService = explicitService;
    }

    public static ObserveProvider create() {
        return HealthObserveProvider.create(HealthFeature.create(new HealthCheck[0]));
    }

    public static ObserveProvider create(HealthFeature service) {
        return new HealthObserveProvider(service);
    }

    public String configKey() {
        return "health";
    }

    public String defaultEndpoint() {
        return this.explicitService == null ? "health" : this.explicitService.configuredContext();
    }

    public void register(Config config, String componentPath, HttpRouting.Builder routing) {
        HealthFeature observer;
        HealthFeature healthFeature = observer = this.explicitService == null ? ((HealthFeature.Builder)HealthFeature.builder().webContext(componentPath)).config(config).build() : this.explicitService;
        if (observer.enabled()) {
            observer.context(componentPath);
            routing.addFeature((Supplier)((Object)observer));
        } else {
            routing.get(componentPath + "/*", new Handler[]{(req, res) -> res.status(Http.Status.SERVICE_UNAVAILABLE_503).send()});
        }
    }
}

