/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.observe.health;

import io.helidon.builder.api.RuntimeType;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.config.Config;
import io.helidon.health.HealthCheck;
import io.helidon.health.spi.HealthCheckProvider;
import io.helidon.http.HttpException;
import io.helidon.http.Status;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.http.HttpService;
import io.helidon.webserver.observe.health.HealthObserverConfig;
import io.helidon.webserver.observe.health.HealthService;
import io.helidon.webserver.observe.spi.Observer;
import io.helidon.webserver.spi.ServerFeature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

@RuntimeType.PrototypedBy(value=HealthObserverConfig.class)
public class HealthObserver
implements Observer,
RuntimeType.Api<HealthObserverConfig> {
    private final HealthObserverConfig config;
    private final List<HealthCheck> all;

    private HealthObserver(HealthObserverConfig config) {
        this.config = config;
        ArrayList<HealthCheck> checks = new ArrayList<HealthCheck>(config.healthChecks());
        if (config.useSystemServices()) {
            Config cfg = config.config().orElseGet(Config::empty);
            HelidonServiceLoader.create(ServiceLoader.load(HealthCheckProvider.class)).asList().stream().map(provider -> provider.healthChecks(cfg)).flatMap(Collection::stream).forEach(checks::add);
        }
        this.all = List.copyOf(checks);
    }

    public static HealthObserver create(HealthCheck ... healthChecks) {
        return ((HealthObserverConfig.Builder)((Object)((HealthObserverConfig.Builder)((Object)HealthObserver.builder().useSystemServices(false))).addHealthChecks(Arrays.asList(healthChecks)))).build();
    }

    public static HealthObserverConfig.Builder builder() {
        return HealthObserverConfig.builder();
    }

    public static HealthObserver create(HealthObserverConfig config) {
        return new HealthObserver(config);
    }

    public static HealthObserver create(Consumer<HealthObserverConfig.Builder> consumer) {
        return ((HealthObserverConfig.Builder)HealthObserver.builder().update(consumer)).build();
    }

    public void register(ServerFeature.ServerFeatureContext featureContext, List<HttpRouting.Builder> observeEndpointRouting, UnaryOperator<String> endpointFunction) {
        String endpoint = (String)endpointFunction.apply(this.config.endpoint());
        if (this.config.enabled()) {
            for (HttpRouting.Builder routing : observeEndpointRouting) {
                routing.register(endpoint, new HttpService[]{new HealthService(this.config, this.all)});
            }
        } else {
            for (HttpRouting.Builder builder : observeEndpointRouting) {
                builder.any(endpoint + "/*", new Handler[]{(req, res) -> {
                    throw new HttpException("Health endpoint is disabled", Status.SERVICE_UNAVAILABLE_503, true);
                }});
            }
        }
    }

    public String type() {
        return "health";
    }

    public HealthObserverConfig prototype() {
        return this.config;
    }
}

