/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.observe.health;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigBuilderSupport;
import io.helidon.health.HealthCheck;
import io.helidon.health.HealthCheckResponse;
import io.helidon.health.HealthCheckType;
import io.helidon.webserver.observe.ObserverConfigBase;
import io.helidon.webserver.observe.health.HealthObserver;
import io.helidon.webserver.observe.health.HealthObserverConfigBlueprint;
import io.helidon.webserver.observe.health.HealthObserverSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.webserver.observe.health.HealthObserverConfigBlueprint")
public interface HealthObserverConfig
extends HealthObserverConfigBlueprint,
Prototype.Api,
ObserverConfigBase {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(HealthObserverConfig instance) {
        return (Builder)((Object)HealthObserverConfig.builder().from(instance));
    }

    public static HealthObserverConfig create(Config config) {
        return ((Builder)HealthObserverConfig.builder().config(config)).buildPrototype();
    }

    public static HealthObserverConfig create() {
        return HealthObserverConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, HealthObserverConfig>
    implements io.helidon.common.Builder<Builder, HealthObserver> {
        private Builder() {
        }

        public HealthObserverConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.HealthObserverConfigImpl(this);
        }

        public HealthObserver build() {
            return HealthObserver.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends HealthObserverConfig>
    extends ObserverConfigBase.BuilderBase<BUILDER, PROTOTYPE>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final List<HealthCheck> healthChecks = new ArrayList<HealthCheck>();
        private boolean details = false;
        private boolean isHealthChecksMutated;
        private boolean useSystemServices = true;
        private Config config;
        private String endpoint = "health";

        protected BuilderBase() {
            this.name("health");
        }

        public BUILDER from(HealthObserverConfig prototype) {
            super.from((ObserverConfigBase)prototype);
            this.endpoint(prototype.endpoint());
            this.details(prototype.details());
            if (!this.isHealthChecksMutated) {
                this.healthChecks.clear();
            }
            this.addHealthChecks(prototype.healthChecks());
            this.useSystemServices(prototype.useSystemServices());
            this.config = prototype.config().orElse(null);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            super.from(builder);
            this.endpoint(builder.endpoint());
            this.details(builder.details());
            if (this.isHealthChecksMutated) {
                if (builder.isHealthChecksMutated) {
                    this.addHealthChecks(builder.healthChecks);
                }
            } else {
                this.healthChecks.clear();
                this.addHealthChecks(builder.healthChecks);
            }
            this.useSystemServices(builder.useSystemServices());
            builder.config().ifPresent(config -> this.config((Config)config));
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER addCheck(HealthCheck check, HealthCheckType type) {
            HealthObserverSupport.CustomMethods.addCheck(this, check, type);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER addCheck(Supplier<HealthCheckResponse> responseSupplier, HealthCheckType type, String name) {
            HealthObserverSupport.CustomMethods.addCheck(this, responseSupplier, type, name);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER addChecks(HealthCheck ... checks) {
            HealthObserverSupport.CustomMethods.addChecks(this, checks);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            super.config(config);
            config.get("endpoint").as(String.class).ifPresent(this::endpoint);
            config.get("details").as(Boolean.class).ifPresent(this::details);
            config.get("use-system-services").as(Boolean.class).ifPresent(this::useSystemServices);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER endpoint(String endpoint) {
            Objects.requireNonNull(endpoint);
            this.endpoint = endpoint;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER details(boolean details) {
            this.details = details;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER healthChecks(List<? extends HealthCheck> healthChecks) {
            Objects.requireNonNull(healthChecks);
            this.isHealthChecksMutated = true;
            this.healthChecks.clear();
            this.healthChecks.addAll(healthChecks);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER addHealthChecks(List<? extends HealthCheck> healthChecks) {
            Objects.requireNonNull(healthChecks);
            this.isHealthChecksMutated = true;
            this.healthChecks.addAll(healthChecks);
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER addCheck(HealthCheck check) {
            Objects.requireNonNull(check);
            this.healthChecks.add(check);
            this.isHealthChecksMutated = true;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public BUILDER useSystemServices(boolean useSystemServices) {
            this.useSystemServices = useSystemServices;
            return (BUILDER)((Object)((BuilderBase)((Object)this.self())));
        }

        public String endpoint() {
            return this.endpoint;
        }

        public boolean details() {
            return this.details;
        }

        public List<HealthCheck> healthChecks() {
            return this.healthChecks;
        }

        public boolean useSystemServices() {
            return this.useSystemServices;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "HealthObserverConfigBuilder{endpoint=" + this.endpoint + ",details=" + this.details + ",healthChecks=" + String.valueOf(this.healthChecks) + ",useSystemServices=" + this.useSystemServices + ",config=" + String.valueOf(this.config) + "};" + super.toString();
        }

        protected void preBuildPrototype() {
            super.preBuildPrototype();
        }

        protected void validatePrototype() {
            super.validatePrototype();
        }

        protected static class HealthObserverConfigImpl
        extends ObserverConfigBase.BuilderBase.ObserverConfigBaseImpl
        implements HealthObserverConfig,
        Supplier<HealthObserver> {
            private final boolean details;
            private final boolean useSystemServices;
            private final List<HealthCheck> healthChecks;
            private final Optional<Config> config;
            private final String endpoint;

            protected HealthObserverConfigImpl(BuilderBase<?, ?> builder) {
                super(builder);
                this.endpoint = builder.endpoint();
                this.details = builder.details();
                this.healthChecks = List.copyOf(builder.healthChecks());
                this.useSystemServices = builder.useSystemServices();
                this.config = builder.config();
            }

            public HealthObserver build() {
                return HealthObserver.create(this);
            }

            @Override
            public HealthObserver get() {
                return this.build();
            }

            @Override
            public String endpoint() {
                return this.endpoint;
            }

            @Override
            public boolean details() {
                return this.details;
            }

            @Override
            public List<HealthCheck> healthChecks() {
                return this.healthChecks;
            }

            @Override
            public boolean useSystemServices() {
                return this.useSystemServices;
            }

            @Override
            public Optional<Config> config() {
                return this.config;
            }

            public String toString() {
                return "HealthObserverConfig{endpoint=" + this.endpoint + ",details=" + this.details + ",healthChecks=" + String.valueOf(this.healthChecks) + ",useSystemServices=" + this.useSystemServices + ",config=" + String.valueOf(this.config) + "};" + super.toString();
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof HealthObserverConfig)) {
                    return false;
                }
                HealthObserverConfig other = (HealthObserverConfig)o;
                return super.equals((Object)other) && Objects.equals(this.endpoint, other.endpoint()) && this.details == other.details() && Objects.equals(this.healthChecks, other.healthChecks()) && this.useSystemServices == other.useSystemServices() && Objects.equals(this.config, other.config());
            }

            public int hashCode() {
                return 31 * super.hashCode() + Objects.hash(this.endpoint, this.details, this.healthChecks, this.useSystemServices, this.config);
            }
        }
    }
}

