/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.observe.metrics;

import io.helidon.metrics.api.Counter;
import io.helidon.metrics.api.Gauge;
import io.helidon.metrics.api.KeyPerformanceIndicatorMetricsConfig;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.webserver.KeyPerformanceIndicatorSupport;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

class KeyPerformanceIndicatorMetricsImpls {
    static final String REQUESTS_COUNT_NAME = "count";
    static final String INFLIGHT_REQUESTS_NAME = "inFlight";
    static final String LONG_RUNNING_REQUESTS_NAME = "longRunning";
    static final String LOAD_NAME = "load";
    public static final String DEFERRED_NAME = "deferred";
    static final String KPI_METERS_SCOPE = "vendor";
    private static final Map<String, KeyPerformanceIndicatorSupport.Metrics> KPI_METRICS = new HashMap<String, KeyPerformanceIndicatorSupport.Metrics>();

    private KeyPerformanceIndicatorMetricsImpls() {
    }

    static KeyPerformanceIndicatorSupport.Metrics get(MeterRegistry kpiMeterRegistry, String meterNamePrefix, KeyPerformanceIndicatorMetricsConfig kpiConfig) {
        return KPI_METRICS.computeIfAbsent(meterNamePrefix, prefix -> kpiConfig.extended() ? new Extended(kpiMeterRegistry, meterNamePrefix, kpiConfig) : new Basic(kpiMeterRegistry, meterNamePrefix));
    }

    private static class Extended
    extends Basic {
        private final Gauge inflightRequests;
        private final DeferredRequests deferredRequests;
        private final Counter longRunningRequests;
        private final Counter load;
        private final long longRunningRequestThresdholdMs;
        private AtomicInteger inflightRequestsCount = new AtomicInteger();
        protected static final String LOAD_DESCRIPTION = "Measures the total number of in-flight requests over the life of the server";

        protected Extended(MeterRegistry kpiMeterRegistry, String meterNamePrefix, KeyPerformanceIndicatorMetricsConfig kpiConfig) {
            this(kpiMeterRegistry, meterNamePrefix, kpiConfig.longRunningRequestThreshold());
        }

        private Extended(MeterRegistry kpiMeterRegistry, String meterNamePrefix, Duration longRunningRequestThreshold) {
            super(kpiMeterRegistry, meterNamePrefix);
            this.longRunningRequestThresdholdMs = longRunningRequestThreshold.toMillis();
            this.inflightRequests = (Gauge)kpiMeterRegistry.getOrCreate((Meter.Builder)Gauge.builder((String)(meterNamePrefix + KeyPerformanceIndicatorMetricsImpls.INFLIGHT_REQUESTS_NAME), (Object)this.inflightRequestsCount, AtomicInteger::get));
            this.longRunningRequests = (Counter)kpiMeterRegistry.getOrCreate((Meter.Builder)((Counter.Builder)Counter.builder((String)(meterNamePrefix + KeyPerformanceIndicatorMetricsImpls.LONG_RUNNING_REQUESTS_NAME)).description("Measures the total number of long-running requests and rates at which they occur")));
            this.load = (Counter)kpiMeterRegistry.getOrCreate((Meter.Builder)((Counter.Builder)Counter.builder((String)(meterNamePrefix + KeyPerformanceIndicatorMetricsImpls.LOAD_NAME)).description(LOAD_DESCRIPTION)));
            this.deferredRequests = new DeferredRequests();
            kpiMeterRegistry.getOrCreate((Meter.Builder)((Gauge.Builder)Gauge.builder((String)(meterNamePrefix + KeyPerformanceIndicatorMetricsImpls.DEFERRED_NAME), (Object)this.deferredRequests, DeferredRequests::value).description("Measures deferred requests")));
        }

        @Override
        public void onRequestReceived() {
            super.onRequestReceived();
            this.deferredRequests.deferRequest();
        }

        public void onRequestStarted() {
            super.onRequestStarted();
            this.inflightRequestsCount.incrementAndGet();
            this.load.increment();
            this.deferredRequests.startRequest();
        }

        public void onRequestCompleted(boolean isSuccessful, long processingTimeMs) {
            super.onRequestCompleted(isSuccessful, processingTimeMs);
            this.inflightRequestsCount.decrementAndGet();
            if (processingTimeMs >= this.longRunningRequestThresdholdMs) {
                this.longRunningRequests.increment();
            }
            this.deferredRequests.completeRequest();
        }

        private static class DeferredRequests {
            private long hits;
            private long load;

            private DeferredRequests() {
            }

            void deferRequest() {
                ++this.hits;
            }

            void startRequest() {
                ++this.load;
            }

            void completeRequest() {
                --this.hits;
                --this.load;
            }

            double value() {
                return this.hits - this.load;
            }
        }
    }

    private static class Basic
    implements KeyPerformanceIndicatorSupport.Metrics {
        private final Counter totalCount;

        protected Basic(MeterRegistry kpiMeterRegistry, String meterNamePrefix) {
            this.totalCount = (Counter)kpiMeterRegistry.getOrCreate((Meter.Builder)((Counter.Builder)((Counter.Builder)Counter.builder((String)(meterNamePrefix + KeyPerformanceIndicatorMetricsImpls.REQUESTS_COUNT_NAME)).description("Each request (regardless of HTTP method) will increase this counter")).scope(KeyPerformanceIndicatorMetricsImpls.KPI_METERS_SCOPE)));
        }

        public void onRequestReceived() {
            this.totalCount.increment();
        }

        protected Counter totalCount() {
            return this.totalCount;
        }
    }
}

