/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.observe.metrics;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.LazyValue;
import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.config.Config;
import io.helidon.config.metadata.ConfiguredOption;
import io.helidon.http.Http;
import io.helidon.http.HttpException;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.metrics.api.MeterRegistryFormatter;
import io.helidon.metrics.api.MetricsConfig;
import io.helidon.metrics.api.MetricsFactory;
import io.helidon.metrics.api.SystemTagsManager;
import io.helidon.metrics.spi.MeterRegistryFormatterProvider;
import io.helidon.webserver.KeyPerformanceIndicatorSupport;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.http.HttpRules;
import io.helidon.webserver.http.HttpService;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import io.helidon.webserver.observe.metrics.KeyPerformanceIndicatorMetricsImpls;
import io.helidon.webserver.observe.metrics.PostRequestMetricsSupport;
import io.helidon.webserver.servicecommon.HelidonFeatureSupport;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Supplier;

public class MetricsFeature
extends HelidonFeatureSupport {
    static final String KPI_METER_NAME_PREFIX = "requests";
    private static final String KPI_METER_NAME_PREFIX_WITH_DOT = "requests.";
    private static final System.Logger LOGGER = System.getLogger(MetricsFeature.class.getName());
    private static final Handler DISABLED_ENDPOINT_HANDLER = (req, res) -> res.status(Http.Status.NOT_FOUND_404).send((Object)"Metrics are disabled");
    private static final Iterable<String> EMPTY_ITERABLE = Collections::emptyIterator;
    private final MetricsConfig metricsConfig;
    private final MeterRegistry meterRegistry;

    private MetricsFeature(Builder builder) {
        super(LOGGER, (HelidonFeatureSupport.Builder)builder, "Metrics");
        this.meterRegistry = builder.meterRegistry();
        this.metricsConfig = builder.metricsConfig();
    }

    protected MetricsFeature(System.Logger logger, Builder builder, String serviceName) {
        super(logger, (HelidonFeatureSupport.Builder)builder, serviceName);
        this.metricsConfig = null;
        this.meterRegistry = null;
    }

    public static MetricsFeature create() {
        return MetricsFeature.builder().build();
    }

    public static MetricsFeature create(Config config) {
        return MetricsFeature.builder().config(config).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<HttpService> service() {
        return Optional.of(rules -> {
            if (this.metricsConfig.enabled()) {
                this.setUpEndpoints(rules);
            } else {
                this.setUpDisabledEndpoints(rules);
            }
        });
    }

    public void configureVendorMetrics(HttpRouting.Builder rules) {
        KeyPerformanceIndicatorSupport.Metrics kpiMetrics = KeyPerformanceIndicatorMetricsImpls.get(this.meterRegistry, KPI_METER_NAME_PREFIX_WITH_DOT, this.metricsConfig.keyPerformanceIndicatorMetricsConfig());
        rules.addFilter((chain, req, res) -> {
            KeyPerformanceIndicatorSupport.Context kpiContext = MetricsFeature.kpiContext((ServerRequest)req);
            PostRequestMetricsSupport prms = PostRequestMetricsSupport.create();
            req.context().register((Object)prms);
            kpiContext.requestHandlingStarted(kpiMetrics);
            try {
                chain.proceed();
                this.postRequestProcessing(prms, (ServerRequest)req, (ServerResponse)res, null, kpiContext);
            }
            catch (Exception e) {
                this.postRequestProcessing(prms, (ServerRequest)req, (ServerResponse)res, e, kpiContext);
            }
        });
    }

    protected void context(String context) {
        super.context(context);
    }

    protected void postSetup(HttpRouting.Builder defaultRouting, HttpRouting.Builder featureRouting) {
        this.configureVendorMetrics(defaultRouting);
    }

    Optional<?> output(MediaType mediaType, Iterable<String> scopeSelection, Iterable<String> nameSelection) {
        MeterRegistryFormatter formatter = this.chooseFormatter(this.meterRegistry, mediaType, SystemTagsManager.instance().scopeTagName(), scopeSelection, nameSelection);
        return formatter.format();
    }

    private MeterRegistryFormatter chooseFormatter(MeterRegistry meterRegistry, MediaType mediaType, Optional<String> scopeTagName, Iterable<String> scopeSelection, Iterable<String> nameSelection) {
        Optional<MeterRegistryFormatter> formatter = HelidonServiceLoader.builder(ServiceLoader.load(MeterRegistryFormatterProvider.class)).build().stream().map(provider -> provider.formatter(mediaType, this.metricsConfig, meterRegistry, scopeTagName, scopeSelection, nameSelection)).filter(Optional::isPresent).map(Optional::get).findFirst();
        if (formatter.isPresent()) {
            return formatter.get();
        }
        throw new HttpException("Unsupported media type for metrics formatting: " + String.valueOf(mediaType), Http.Status.UNSUPPORTED_MEDIA_TYPE_415, true);
    }

    private void getAll(ServerRequest req, ServerResponse res) {
        this.getMatching(req, res, req.query().all("scope", List::of), req.query().all("name", List::of));
    }

    private void getMatching(ServerRequest req, ServerResponse res, Iterable<String> scopeSelection, Iterable<String> nameSelection) {
        MediaType mediaType = MetricsFeature.bestAccepted(req);
        res.header(Http.Headers.CACHE_NO_CACHE);
        if (mediaType == null) {
            res.status(Http.Status.NOT_ACCEPTABLE_406);
            res.send();
        }
        this.getOrOptionsMatching(mediaType, res, () -> this.output(mediaType, scopeSelection, nameSelection));
    }

    private void getOrOptionsMatching(MediaType mediaType, ServerResponse res, Supplier<Optional<?>> dataSupplier) {
        Optional<?> output = dataSupplier.get();
        if (output.isPresent()) {
            res.status(Http.Status.OK_200).headers().contentType(mediaType);
            res.send(output.get());
        } else {
            res.status(Http.Status.NOT_FOUND_404);
            res.send();
        }
    }

    private static MediaType bestAccepted(ServerRequest req) {
        return req.headers().bestAccepted(new MediaType[]{MediaTypes.TEXT_PLAIN, MediaTypes.APPLICATION_OPENMETRICS_TEXT, MediaTypes.APPLICATION_JSON}).orElse(null);
    }

    private static MediaType bestAcceptedForMetadata(ServerRequest req) {
        return req.headers().bestAccepted(new MediaType[]{MediaTypes.APPLICATION_JSON}).orElse(null);
    }

    private static KeyPerformanceIndicatorSupport.Context kpiContext(ServerRequest request) {
        return request.context().get(KeyPerformanceIndicatorSupport.Context.class).orElseGet(KeyPerformanceIndicatorSupport.Context::create);
    }

    private void setUpEndpoints(HttpRules rules) {
        rules.get("/", new Handler[]{this::getAll}).options("/", new Handler[]{this::optionsAll});
        Meter.Scope.BUILT_IN_SCOPES.forEach(scope -> {
            boolean isScopeEnabled = this.metricsConfig.isScopeEnabled(scope);
            rules.get("/" + scope, new Handler[]{isScopeEnabled ? (req, res) -> this.getMatching(req, res, Set.of(scope), Set.of()) : DISABLED_ENDPOINT_HANDLER}).get("/" + scope + "/{metric}", new Handler[]{isScopeEnabled ? (req, res) -> this.getByName(req, res, Set.of(scope)) : DISABLED_ENDPOINT_HANDLER}).options("/" + scope, new Handler[]{isScopeEnabled ? (req, res) -> this.optionsMatching(req, res, Set.of(scope), Set.of()) : DISABLED_ENDPOINT_HANDLER}).options("/" + scope + "/{metric}", new Handler[]{isScopeEnabled ? (req, res) -> this.optionsByName(req, res, Set.of(scope)) : DISABLED_ENDPOINT_HANDLER});
        });
    }

    private void getByName(ServerRequest req, ServerResponse res, Iterable<String> scopeSelection) {
        String metricName = req.path().pathParameters().get("metric");
        this.getMatching(req, res, scopeSelection, Set.of(metricName));
    }

    private void postRequestProcessing(PostRequestMetricsSupport prms, ServerRequest request, ServerResponse response, Throwable throwable, KeyPerformanceIndicatorSupport.Context kpiContext) {
        kpiContext.requestProcessingCompleted(throwable == null && response.status().code() < 500);
        prms.runTasks(request, response, throwable);
    }

    private void optionsAll(ServerRequest req, ServerResponse res) {
        this.optionsMatching(req, res, req.query().all("scope", List::of), req.query().all("name", List::of));
    }

    private void optionsByName(ServerRequest req, ServerResponse res, Iterable<String> scopeSelection) {
        String metricName = req.path().pathParameters().get("metric");
        this.optionsMatching(req, res, scopeSelection, Set.of(metricName));
    }

    private void optionsMatching(ServerRequest req, ServerResponse res, Iterable<String> scopeSelection, Iterable<String> nameSelection) {
        MediaType mediaType = MetricsFeature.bestAcceptedForMetadata(req);
        if (mediaType == null) {
            res.header(Http.HeaderNames.ALLOW, new String[]{"GET"});
            res.status(Http.Status.METHOD_NOT_ALLOWED_405);
            res.send();
        }
        this.getOrOptionsMatching(mediaType, res, () -> this.output(mediaType, scopeSelection, nameSelection));
    }

    private void setUpDisabledEndpoints(HttpRules rules) {
        rules.get("/", new Handler[]{DISABLED_ENDPOINT_HANDLER}).options("/", new Handler[]{DISABLED_ENDPOINT_HANDLER});
    }

    public static class Builder
    extends HelidonFeatureSupport.Builder<Builder, MetricsFeature> {
        private LazyValue<MeterRegistry> meterRegistry;
        private MetricsConfig.Builder metricsSettingsBuilder = MetricsConfig.builder();

        private Builder() {
            super("metrics");
        }

        protected Builder(String serviceName) {
            super(serviceName);
        }

        public MetricsFeature build() {
            if (this.meterRegistry == null) {
                this.meterRegistry = LazyValue.create(() -> MetricsFactory.getInstance().globalRegistry());
            }
            return new MetricsFeature(this);
        }

        public Builder config(Config config) {
            super.config((io.helidon.common.config.Config)config);
            this.metricsSettingsBuilder.config((io.helidon.common.config.Config)config);
            return this;
        }

        @ConfiguredOption(mergeWithParent=true, type=MetricsConfig.class)
        public Builder metricsConfig(MetricsConfig.Builder metricsSettingsBuilder) {
            this.metricsSettingsBuilder = metricsSettingsBuilder;
            return this;
        }

        public Builder meterRegistry(MeterRegistry meterRegistry) {
            this.meterRegistry = LazyValue.create(() -> meterRegistry);
            return this;
        }

        MeterRegistry meterRegistry() {
            return (MeterRegistry)this.meterRegistry.get();
        }

        MetricsConfig metricsConfig() {
            return this.metricsSettingsBuilder.build();
        }
    }
}

