/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.observe.metrics;

import io.helidon.common.config.Config;
import io.helidon.http.Http;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.observe.metrics.MetricsFeature;
import io.helidon.webserver.observe.spi.ObserveProvider;
import java.util.function.Supplier;

public class MetricsObserveProvider
implements ObserveProvider {
    private final MetricsFeature explicitService;

    @Deprecated
    public MetricsObserveProvider() {
        this(null);
    }

    private MetricsObserveProvider(MetricsFeature explicitService) {
        this.explicitService = explicitService;
    }

    public static ObserveProvider create() {
        return MetricsObserveProvider.create(MetricsFeature.create());
    }

    public static ObserveProvider create(MetricsFeature service) {
        return new MetricsObserveProvider(service);
    }

    public String configKey() {
        return "metrics";
    }

    public String defaultEndpoint() {
        return this.explicitService == null ? "metrics" : this.explicitService.configuredContext();
    }

    public void register(Config config, String componentPath, HttpRouting.Builder routing) {
        MetricsFeature observer;
        MetricsFeature metricsFeature = observer = this.explicitService == null ? ((MetricsFeature.Builder)((MetricsFeature.Builder)MetricsFeature.builder().webContext(componentPath)).config(config)).build() : this.explicitService;
        if (observer.enabled()) {
            observer.context(componentPath);
            routing.addFeature((Supplier)((Object)observer));
        } else {
            String finalPath = componentPath + (componentPath.endsWith("/") ? "*" : "/*");
            routing.get(finalPath, new Handler[]{(req, res) -> res.status(Http.Status.SERVICE_UNAVAILABLE_503).send()});
        }
    }
}

