/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.observe.metrics;

import io.helidon.metrics.api.Counter;
import io.helidon.metrics.api.DistributionSummary;
import io.helidon.metrics.api.FunctionalCounter;
import io.helidon.metrics.api.Gauge;
import io.helidon.metrics.api.HistogramSnapshot;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.metrics.api.MeterRegistryFormatter;
import io.helidon.metrics.api.MetricsConfig;
import io.helidon.metrics.api.SystemTagsManager;
import io.helidon.metrics.api.Timer;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObjectBuilder;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAccumulator;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

class JsonFormatter
implements MeterRegistryFormatter {
    private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Map.of());
    private static final Map<String, String> JSON_ESCAPED_CHARS_MAP = JsonFormatter.initEscapedCharsMap();
    private static final Pattern JSON_ESCAPED_CHARS_REGEX = Pattern.compile(JSON_ESCAPED_CHARS_MAP.keySet().stream().map(Pattern::quote).collect(Collectors.joining("", "[", "]")));
    private final Iterable<String> meterNameSelection;
    private final Iterable<String> scopeSelection;
    private final String scopeTagName;
    private final MetricsConfig metricsConfig;
    private final MeterRegistry meterRegistry;

    private JsonFormatter(Builder builder) {
        this.meterNameSelection = builder.meterNameSelection;
        this.scopeSelection = builder.scopeSelection;
        this.scopeTagName = builder.scopeTagName;
        this.metricsConfig = builder.metricsConfig;
        this.meterRegistry = builder.meterRegistry;
    }

    static Builder builder(MetricsConfig metricsConfig, MeterRegistry meterRegistry) {
        return new Builder(metricsConfig, meterRegistry);
    }

    static String jsonEscape(String s) {
        Matcher m = JSON_ESCAPED_CHARS_REGEX.matcher(s);
        StringBuilder sb = new StringBuilder();
        while (m.find()) {
            m.appendReplacement(sb, JSON_ESCAPED_CHARS_MAP.get(m.group()));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public Optional<Object> format() {
        boolean organizeByScope = this.shouldOrganizeByScope();
        HashMap<String, Map> meterOutputBuildersByScope = organizeByScope ? new HashMap<String, Map>() : null;
        HashMap<String, MetricOutputBuilder> meterOutputBuildersIgnoringScope = organizeByScope ? null : new HashMap<String, MetricOutputBuilder>();
        AtomicBoolean isAnyOutput = new AtomicBoolean(false);
        this.meterRegistry.meters(this.scopeSelection).forEach(meter -> {
            String name = meter.id().name();
            if (this.meterRegistry.isMeterEnabled(name, meter.id().tagsMap(), meter.scope()) && this.matchesName(name)) {
                Map meterOutputBuilderMapToUpdate = organizeByScope ? meterOutputBuildersByScope.computeIfAbsent(meter.scope().orElse(""), ms -> new HashMap()) : meterOutputBuildersIgnoringScope;
                MetricOutputBuilder metricOutputBuilder = meterOutputBuilderMapToUpdate.computeIfAbsent(JsonFormatter.metricOutputKey(meter), k -> MetricOutputBuilder.create(meter));
                metricOutputBuilder.add((Meter)meter);
                isAnyOutput.set(true);
            }
        });
        JsonObjectBuilder top = JSON.createObjectBuilder();
        if (organizeByScope) {
            meterOutputBuildersByScope.forEach((scope, outputBuilders) -> {
                JsonObjectBuilder scopeBuilder = JSON.createObjectBuilder();
                outputBuilders.forEach((key, outputBuilder) -> outputBuilder.apply(scopeBuilder));
                top.add(scope, scopeBuilder);
            });
        } else {
            meterOutputBuildersIgnoringScope.forEach((key, outputBuilder) -> outputBuilder.apply(top));
        }
        return isAnyOutput.get() ? Optional.of(top.build()) : Optional.empty();
    }

    public Optional<Object> formatMetadata() {
        boolean organizeByScope = this.shouldOrganizeByScope();
        HashMap<String, Map> metadataOutputBuildersByScope = organizeByScope ? new HashMap<String, Map>() : null;
        HashMap<String, JsonObjectBuilder> metadataOutputBuildersIgnoringScope = organizeByScope ? null : new HashMap<String, JsonObjectBuilder>();
        AtomicBoolean isAnyOutput = new AtomicBoolean(false);
        this.meterRegistry.meters(this.scopeSelection).forEach(meter -> {
            String name = meter.id().name();
            if (this.meterRegistry.isMeterEnabled(name, meter.id().tagsMap(), meter.scope()) && this.matchesName(name)) {
                Map metadataOutputBuilderWithinParent = organizeByScope ? metadataOutputBuildersByScope.computeIfAbsent(meter.scope().orElse(""), ms -> new HashMap()) : metadataOutputBuildersIgnoringScope;
                JsonObjectBuilder builderForThisName = metadataOutputBuilderWithinParent.computeIfAbsent(name, k -> JSON.createObjectBuilder());
                JsonFormatter.addNonEmpty(builderForThisName, "type", meter.type().typeName());
                meter.baseUnit().ifPresent(u -> JsonFormatter.addNonEmpty(builderForThisName, "unit", u));
                meter.description().ifPresent(d -> JsonFormatter.addNonEmpty(builderForThisName, "description", d));
                isAnyOutput.set(true);
                ArrayList<List<String>> tagGroups = new ArrayList<List<String>>();
                List<String> tags = StreamSupport.stream(SystemTagsManager.instance().withoutSystemOrScopeTags(meter.id().tags()).spliterator(), false).map(tag -> JsonFormatter.jsonEscape(tag.key()) + "=" + JsonFormatter.jsonEscape(tag.value())).toList();
                if (!tags.isEmpty()) {
                    tagGroups.add(tags);
                }
                if (!tagGroups.isEmpty()) {
                    JsonArrayBuilder tagsOverAllMetricsWithSameName = JSON.createArrayBuilder();
                    for (List list : tagGroups) {
                        JsonArrayBuilder tagsForMetricBuilder = JSON.createArrayBuilder();
                        list.forEach(arg_0 -> ((JsonArrayBuilder)tagsForMetricBuilder).add(arg_0));
                        tagsOverAllMetricsWithSameName.add(tagsForMetricBuilder);
                    }
                    builderForThisName.add("tags", tagsOverAllMetricsWithSameName);
                    isAnyOutput.set(true);
                }
            }
        });
        JsonObjectBuilder top = JSON.createObjectBuilder();
        if (organizeByScope) {
            metadataOutputBuildersByScope.forEach((scope, builders) -> {
                JsonObjectBuilder scopeBuilder = JSON.createObjectBuilder();
                builders.forEach((arg_0, arg_1) -> ((JsonObjectBuilder)scopeBuilder).add(arg_0, arg_1));
                top.add(scope, scopeBuilder);
            });
        } else {
            metadataOutputBuildersIgnoringScope.forEach((arg_0, arg_1) -> ((JsonObjectBuilder)top).add(arg_0, arg_1));
        }
        return isAnyOutput.get() ? Optional.of(top.build()) : Optional.empty();
    }

    private static Map<String, String> initEscapedCharsMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("\b", JsonFormatter.bsls("b"));
        result.put("\f", JsonFormatter.bsls("f"));
        result.put("\n", JsonFormatter.bsls("n"));
        result.put("\r", JsonFormatter.bsls("r"));
        result.put("\t", JsonFormatter.bsls("t"));
        result.put("\"", JsonFormatter.bsls("\""));
        result.put("\\", JsonFormatter.bsls("\\\\"));
        result.put(";", "_");
        return result;
    }

    private static String bsls(String s) {
        return "\\\\" + s;
    }

    private static void addNonEmpty(JsonObjectBuilder builder, String name, String value) {
        if (null != value && !value.isEmpty()) {
            builder.add(name, value);
        }
    }

    private static String metricOutputKey(Meter meter) {
        return meter instanceof Counter || meter instanceof Gauge ? JsonFormatter.flatNameAndTags(meter.id()) : JsonFormatter.structureName(meter.id());
    }

    private static String flatNameAndTags(Meter.Id meterId) {
        StringJoiner sj = new StringJoiner(";");
        sj.add(meterId.name());
        SystemTagsManager.instance().withoutSystemOrScopeTags(meterId.tags()).forEach(tag -> sj.add(tag.key() + "=" + tag.value()));
        return sj.toString();
    }

    private static String structureName(Meter.Id meterId) {
        return meterId.name();
    }

    private boolean shouldOrganizeByScope() {
        Iterator<String> it = this.scopeSelection.iterator();
        if (it.hasNext()) {
            it.next();
            return it.hasNext();
        }
        return true;
    }

    private Iterable<String> scopesToReport() {
        HashSet selection = new HashSet();
        this.scopeSelection.forEach(selection::add);
        ArrayList<String> scopesToReport = new ArrayList<String>();
        if (!selection.isEmpty()) {
            this.meterRegistry.scopes().forEach(candidateScope -> {
                if (selection.contains(candidateScope)) {
                    scopesToReport.add((String)candidateScope);
                }
            });
        }
        return scopesToReport;
    }

    private boolean matchesName(String metricName) {
        Iterator<String> nameIterator = this.meterNameSelection.iterator();
        if (!nameIterator.hasNext()) {
            return true;
        }
        while (nameIterator.hasNext()) {
            if (!nameIterator.next().equals(metricName)) continue;
            return true;
        }
        return false;
    }

    static class Builder
    implements io.helidon.common.Builder<Builder, JsonFormatter> {
        private final MetricsConfig metricsConfig;
        private final MeterRegistry meterRegistry;
        private Iterable<String> meterNameSelection = Set.of();
        private String scopeTagName;
        private Iterable<String> scopeSelection = Set.of();

        private Builder(MetricsConfig metricsConfig, MeterRegistry meterRegistry) {
            this.metricsConfig = metricsConfig;
            this.meterRegistry = meterRegistry;
        }

        public JsonFormatter build() {
            return new JsonFormatter(this);
        }

        public Builder meterNameSelection(Iterable<String> meterNameSelection) {
            this.meterNameSelection = meterNameSelection;
            return (Builder)this.identity();
        }

        public Builder scopeSelection(Iterable<String> scopeSelection) {
            this.scopeSelection = scopeSelection;
            return (Builder)this.identity();
        }

        public Builder scopeTagName(String scopeTagName) {
            this.scopeTagName = scopeTagName;
            return (Builder)this.identity();
        }
    }

    private static abstract class MetricOutputBuilder {
        private final Meter meter;

        protected MetricOutputBuilder(Meter meter) {
            this.meter = meter;
        }

        protected Meter meter() {
            return this.meter;
        }

        protected abstract void add(Meter var1);

        protected abstract void apply(JsonObjectBuilder var1);

        private static MetricOutputBuilder create(Meter meter) {
            return meter instanceof Counter || meter instanceof Gauge || meter instanceof FunctionalCounter ? new Flat(meter) : new Structured(meter);
        }

        private static void addNarrowed(JsonObjectBuilder builder, String nameWithTags, Number number) {
            if (number instanceof AtomicInteger) {
                AtomicInteger v = (AtomicInteger)number;
                builder.add(nameWithTags, v.intValue());
            } else if (number instanceof AtomicLong) {
                AtomicLong v = (AtomicLong)number;
                builder.add(nameWithTags, v.longValue());
            } else if (number instanceof BigDecimal) {
                BigDecimal v = (BigDecimal)number;
                builder.add(nameWithTags, v);
            } else if (number instanceof BigInteger) {
                BigInteger v = (BigInteger)number;
                builder.add(nameWithTags, v);
            } else if (number instanceof Byte) {
                Byte v = (Byte)number;
                builder.add(nameWithTags, (int)v.byteValue());
            } else if (number instanceof Double) {
                Double v = (Double)number;
                builder.add(nameWithTags, v.doubleValue());
            } else if (number instanceof DoubleAccumulator) {
                DoubleAccumulator v = (DoubleAccumulator)number;
                builder.add(nameWithTags, v.doubleValue());
            } else if (number instanceof DoubleAdder) {
                DoubleAdder v = (DoubleAdder)number;
                builder.add(nameWithTags, v.doubleValue());
            } else if (number instanceof Float) {
                Float v = (Float)number;
                builder.add(nameWithTags, (double)v.floatValue());
            } else if (number instanceof Integer) {
                Integer v = (Integer)number;
                builder.add(nameWithTags, v.intValue());
            } else if (number instanceof Long) {
                Long v = (Long)number;
                builder.add(nameWithTags, v.longValue());
            } else if (number instanceof LongAccumulator) {
                LongAccumulator v = (LongAccumulator)number;
                builder.add(nameWithTags, v.longValue());
            } else if (number instanceof LongAdder) {
                LongAdder v = (LongAdder)number;
                builder.add(nameWithTags, v.longValue());
            } else if (number instanceof Short) {
                Short v = (Short)number;
                builder.add(nameWithTags, (int)v.shortValue());
            }
        }

        private static class Flat
        extends MetricOutputBuilder {
            private Flat(Meter meter) {
                super(meter);
            }

            @Override
            protected void apply(JsonObjectBuilder builder) {
                Meter meter = this.meter();
                if (meter instanceof Counter) {
                    Counter counter = (Counter)meter;
                    builder.add(JsonFormatter.flatNameAndTags(this.meter().id()), counter.count());
                    return;
                }
                meter = this.meter();
                if (meter instanceof Gauge) {
                    Gauge gauge = (Gauge)meter;
                    String nameWithTags = JsonFormatter.flatNameAndTags(this.meter().id());
                    MetricOutputBuilder.addNarrowed(builder, nameWithTags, gauge.value());
                    return;
                }
                meter = this.meter();
                if (meter instanceof FunctionalCounter) {
                    FunctionalCounter fCounter = (FunctionalCounter)meter;
                    builder.add(JsonFormatter.flatNameAndTags(this.meter().id()), fCounter.count());
                    return;
                }
                throw new IllegalArgumentException("Attempt to format meter with structured data as flat JSON " + this.meter().getClass().getName());
            }

            @Override
            protected void add(Meter meter) {
            }
        }

        private static class Structured
        extends MetricOutputBuilder {
            private final List<Meter> children = new ArrayList<Meter>();
            private final JsonObjectBuilder sameNameBuilder = JSON.createObjectBuilder();

            Structured(Meter meter) {
                super(meter);
            }

            @Override
            protected void add(Meter meter) {
                if (!this.meter().getClass().isInstance(meter)) {
                    throw new IllegalArgumentException(String.format("Attempt to add meter of type %s to existing output for a meter of type %s", meter.getClass().getName(), this.meter().getClass().getName()));
                }
                this.children.add(meter);
            }

            @Override
            protected void apply(JsonObjectBuilder builder) {
                Meter.Id meterId = this.meter().id();
                this.children.forEach(child -> {
                    Meter.Id childID = child.id();
                    if (child instanceof Counter) {
                        Counter typedChild = (Counter)child;
                        this.sameNameBuilder.add(Structured.valueId("count", childID), typedChild.count());
                    } else if (child instanceof DistributionSummary) {
                        DistributionSummary typedChild = (DistributionSummary)child;
                        this.sameNameBuilder.add(Structured.valueId("count", childID), typedChild.count());
                        this.sameNameBuilder.add(Structured.valueId("max", childID), typedChild.max());
                        this.sameNameBuilder.add(Structured.valueId("mean", childID), typedChild.mean());
                        this.sameNameBuilder.add(Structured.valueId("total", childID), typedChild.totalAmount());
                        this.addDetails(typedChild.snapshot(), childID, null);
                    } else if (child instanceof Timer) {
                        Timer typedChild = (Timer)child;
                        this.sameNameBuilder.add(Structured.valueId("count", childID), typedChild.count());
                        this.sameNameBuilder.add(Structured.valueId("max", childID), typedChild.max(TimeUnit.SECONDS));
                        this.sameNameBuilder.add(Structured.valueId("mean", childID), typedChild.mean(TimeUnit.SECONDS));
                        this.sameNameBuilder.add(Structured.valueId("elapsedTime", childID), typedChild.totalTime(TimeUnit.SECONDS));
                        this.addDetails(typedChild.snapshot(), childID, Structured.timeUnit(typedChild));
                    } else if (child instanceof FunctionalCounter) {
                        FunctionalCounter typedChild = (FunctionalCounter)child;
                        this.sameNameBuilder.add(Structured.valueId("count", childID), typedChild.count());
                    } else if (child instanceof Gauge) {
                        Gauge typedChild = (Gauge)child;
                        MetricOutputBuilder.addNarrowed(this.sameNameBuilder, Structured.valueId("value", childID), typedChild.value());
                    } else {
                        throw new IllegalArgumentException("Unrecognized meter type " + this.meter().getClass().getName());
                    }
                });
                builder.add(meterId.name(), this.sameNameBuilder);
            }

            private void addDetails(HistogramSnapshot snapshot, Meter.Id childId, TimeUnit timeUnit) {
                snapshot.percentileValues().forEach(vap -> this.sameNameBuilder.add(Structured.valueId(Structured.percentileName(vap.percentile()), childId), timeUnit != null ? vap.value(timeUnit) : vap.value()));
                snapshot.histogramCounts().forEach(bucket -> this.sameNameBuilder.add(Structured.valueId(Structured.bucketName(timeUnit != null ? bucket.boundary(timeUnit) : bucket.boundary()), childId), bucket.count()));
            }

            private static String percentileName(double percentile) {
                return "p" + percentile;
            }

            private static String bucketName(double boundary) {
                return "b" + boundary;
            }

            private static TimeUnit timeUnit(Timer timer) {
                if (timer.baseUnit().isPresent()) {
                    try {
                        return TimeUnit.valueOf(((String)timer.baseUnit().get()).toUpperCase(Locale.getDefault()));
                    }
                    catch (IllegalArgumentException ex) {
                        return TimeUnit.SECONDS;
                    }
                }
                return TimeUnit.SECONDS;
            }

            private static String valueId(String valueName, Meter.Id meterId) {
                return valueName + Structured.tagsPortion(meterId);
            }

            private static String tagsPortion(Meter.Id metricID) {
                StringJoiner sj = new StringJoiner(";", ";", "");
                sj.setEmptyValue("");
                SystemTagsManager.instance().withoutSystemOrScopeTags(metricID.tags()).forEach(tag -> sj.add(tag.key() + "=" + tag.value()));
                return sj.toString();
            }
        }
    }
}

