/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.observe.metrics;

import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.metrics.api.MeterRegistryFormatter;
import io.helidon.metrics.api.MetricsConfig;
import io.helidon.metrics.spi.MeterRegistryFormatterProvider;
import io.helidon.webserver.observe.metrics.JsonFormatter;
import java.util.Optional;

public class JsonMeterRegistryFormatterProvider
implements MeterRegistryFormatterProvider {
    public Optional<MeterRegistryFormatter> formatter(MediaType mediaType, MetricsConfig metricsConfig, MeterRegistry meterRegistry, Optional<String> scopeTagName, Iterable<String> scopeSelection, Iterable<String> nameSelection) {
        return mediaType.type().equals(MediaTypes.APPLICATION_JSON.type()) && mediaType.subtype().equals(MediaTypes.APPLICATION_JSON.subtype()) ? Optional.of(this.create(metricsConfig, meterRegistry, scopeTagName, scopeSelection, nameSelection)) : Optional.empty();
    }

    private JsonFormatter create(MetricsConfig metricsConfig, MeterRegistry meterRegistry, Optional<String> scopeTagName, Iterable<String> scopeSelection, Iterable<String> nameSelection) {
        JsonFormatter.Builder builder = JsonFormatter.builder(metricsConfig, meterRegistry).scopeSelection(scopeSelection).meterNameSelection(nameSelection);
        scopeTagName.ifPresent(builder::scopeTagName);
        return builder.build();
    }
}

